% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustering.R
\name{Clustering}
\alias{Clustering}
\title{A simple and powerful function to create clusters with KMeans}
\usage{
Clustering(data, n = "auto", n_max = 10, iter.max = 10,
  auto_criterion = c("explainWSS", "db", "ratkowsky", "ball",
  "friedman"), confidenceWSS = 0.9, agregate_method = median)
}
\arguments{
\item{data}{Data frame which numeric variables.}

\item{n}{Data frame which numeric variables.}

\item{n_max}{maximal number of clusters, between 2 and (number of objects - 1), greater or equal to n_min. By default, n_max=10.}

\item{iter.max}{the maximum number of iterations allowed.}

\item{auto_criterion}{the available criterions are: "explainWSS",
"db", "ratkowsky", "ball" and "friedman".}

\item{confidenceWSS}{a confidence interval for criterion WSS.}

\item{agregate_method}{a function to agregate results of different methods. Default value=median}
}
\value{
A MLA object of subclass Clustering
}
\description{
This is a modified kmeans clustering technique to automatize the number of groups or clusters that can be partitioned the sample. Several techniques are used to obtain the best number of clusters.
}
\examples{
## Load a Dataset
 \dontrun{
data(EGATUR)
modelFit <- Clustering(data=EGATUR[,c("A13","gastototal")])
}

}
