% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manova.R
\name{Manova}
\alias{Manova}
\title{One Way Multivariate Analysis of Variance (MANOVA)}
\usage{
Manova(data, group, method = "Wilks", CI = "FALSE", alpha = 0.05,
  Homogeneity = TRUE)
}
\arguments{
\item{data}{a data frame.}

\item{group}{a group vector}

\item{method}{The method that will be used for MANOVA. These methods are "Wilks", "Roy" and "Hotelling-Lawley". 
\code{default method="Wilks"}.}

\item{CI}{a logical argument. If \code{CI="TRUE"}, then the decision 
matrices based on confidence intervals obtained for all variables and 
groups are calculated.
CI values are calculated only in Roy method. \code{default CI=FALSE}.}

\item{alpha}{Significance Level that will be used for confidence intervals. \code{default alpha=0.05}}

\item{Homogeneity}{a logical argument. If \code{Homogeneity=TRUE}, 
then classical MANOVA methods which are under the assumption that 
covariance matrices of groups are homogeneity are used.
Otherwise, the MANOVA approach (James, 1954) without homogeneous 
covariance matrices assumption is used. Default \code{Homogeneity=TRUE}. 
The homogeneity test for covariance matrices is performed \code{BoxM} function.}
}
\value{
a list with 9 elements:
\item{Method}{The method used for MANOVA}
\item{Test.Stat}{The value of the test statistic for the selected method}
\item{App.Stat}{The approximate value of F or Chi-Squared statistic. 
The \code{Manova} function uses F statistic when the covariance matrices 
are homogeneity; otherwise, it uses Chi-squared Statistic.}
\item{df}{The F or Chi-Squared statistic's degree of freedom}
\item{p.value}{p value}
\item{Decision.Matrices}{When \code{method="Roy"} and \code{CI="TRUE"},  it gives the 
decision matrices based on confidence intervals obtained for all variables 
and groups.
If between groups decision is TRUE for any variable, it means that 
the mean vectors of these groups are statistically different.
When the covariance matrices are not homogeneity, confidence intervals 
are not calculated.}
\item{alpha}{The alpha value using in confidence intervals}
\item{Descriptive}{Descriptive Statistics for all groups}
\item{Homogeneity}{It gives the result of the assumption that covariance
matrices are homogeneity.}
}
\description{
\code{Manova} function computes one-way MANOVA test and gives confidence 
intervals
}
\details{
This function computes the MANOVA test for more than two independent 
samples with and without the assumption that covariance matrices are 
homogeneity. The hypotheses are \code{H0:Mu_1=Mu_2=...=Mu_g} and
\code{H1:At least a Mu_j is different from others (j=1,2,...,g)}.
When \code{H0} is rejected, this function computes confidence intervals 
for all variables to determine variable(s) affecting on rejection decision.
}
\examples{

data(iris)

# Wilk's Test
results.Wilks <- Manova(data=iris[,1:4],group=iris[,5],alpha=0.01)
summary(results.Wilks)

 
# Hotelling and Lawley's Test
results.HL <- Manova(data=iris[,1:4],group=iris[,5], method="Hotelling-Lawley")
summary(results.HL)

# Roy's Test
results.Roy <- Manova(data=iris[,1:4],group=iris[,5], method="Roy")
summary(results.Roy)

#Roy's Test with Confidence Intervals 
results.RoyCI <- Manova(data=iris[,1:4],group=iris[,5], method="Roy",CI=TRUE)
summary(results.RoyCI)


# James's Test
results.James <- Manova(data=iris[,1:4],group=iris[,5],Homogeneity=FALSE)
summary(results.James)
}
\references{
Rencher, A. C. (2003). Methods of multivariate analysis 
(Vol. 492). John Wiley & Sons.

Tatlidil, H. (1996). Uygulamali Cok Degiskenli Istatistiksel 
Yontemler. Cem Web.

James, G. S. (1954). Tests of linear hypotheses in univariate 
and multivariate analysis when the ratios of the population variances are unknown. Biometrika, 41(1/2), 19-43.

Tsagris M. T. (2014). Multivariate statistical functions 
in R. Athens, Nottingham and Abu Halifa (Kuwait).
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
