% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidev.R
\name{bidev}
\alias{bidev}
\title{Multiscalar Typology (2 deviations)}
\usage{
bidev(x, dev1, dev2, breaks = c(25, 50, 100), xid = NULL)
}
\arguments{
\item{x}{a sf object including 2 deviations among gdev, tdev and sdev.}

\item{dev1}{column name of the first relative deviation in x.}

\item{dev2}{coumn name of the second relative deviation in x.}

\item{breaks}{Distance to the index 100 (average of the context), in
percentage. A vector of three values. Defaut c(25,50,100). 25 % corresponds
to indexes 80 and 125. 50 % to indexes 67 and 150 and 100 % to indexes 50 
and 200.}

\item{xid}{identifier field in x. Default the first column.}
}
\value{
a column in x including a bidev column delivering the result of 
the typology. Values are classified in 13 classes according to their 
respective position on the two selected deviations and their
 distance to the average.
\itemize{bidev typology values :
\item{ZZ: Near the average for the two selected deviation}
\item{A1: Above the average for dev1 and dev2, distance to the avarage : +}
\item{A2: Above the average for dev1 and dev2, distance to the avarage : ++}
\item{A3: Above the average for dev1 and dev2, distance to the avarage : +++}
\item{B1: Above the average for dev1 and below for dev2, distance to the
 avarage : +}
\item{B2: Above the average for dev1 and below for dev2, distance to the
 avarage : ++}
\item{B3: Above the average for dev1 and below for dev2, distance to the
 avarage : +++}
\item{C1: Below the average for dev1 and dev2, distance to the avarage : +}
\item{C2: Below the average for dev1 and dev2, distance to the avarage : ++}
\item{C3: Below the average for dev1 and dev2, distance to the avarage : +++}
\item{D1: Below the average for dev1 and above for dev2, distance to the
 avarage : +}
\item{D2: Below the average for dev1 and above for dev2, distance to the
 avarage : ++}
\item{D3: Below the average for dev1 and above for dev2, distance to the
 avarage : +++}
}
}
\description{
Compute a multiscalar typology according to two relative 
deviations relative.
}
\examples{
# bidev synthesis on general and territorial deviation (income data)
# load data
data("GrandParisMetropole")

# Prerequisite  - Compute 2 deviations
com$gdev <- gdev(x = com, var1 = "INC", var2 = "TH")
com$tdev <- tdev(x = com, var1 = "INC", var2 = "TH", key = "EPT")

# Compute bidev
com$bidev <- bidev(x = com, dev1 = "gdev", dev2 = "tdev")
}
