### R code from vignette source 'examples.rnw'

###################################################
### code chunk number 1: preliminaries
###################################################
library(MSwM)
set.seed(2341)


###################################################
### code chunk number 2: examples.rnw:50-51
###################################################
data(example)


###################################################
### code chunk number 3: examples.rnw:55-56
###################################################
plot(ts(example))


###################################################
### code chunk number 4: examples.rnw:63-65
###################################################
mod=lm(y~x,example)
summary(mod)


###################################################
### code chunk number 5: fig1_3
###################################################
qqnorm(resid(mod))
qqline(resid(mod))


###################################################
### code chunk number 6: fig1_4
###################################################
acf(resid(mod))


###################################################
### code chunk number 7: examples.rnw:88-90
###################################################
mod.mswm=msmFit(mod,k=2,p=1,sw=c(TRUE,TRUE,TRUE,TRUE),control=list(parallel=FALSE))
summary(mod.mswm)


###################################################
### code chunk number 8: examples.rnw:97-98
###################################################
plot(mod.mswm)


###################################################
### code chunk number 9: fig1_6
###################################################
plotDiag(mod.mswm,which=2)


###################################################
### code chunk number 10: fig1_7
###################################################
plotDiag(mod.mswm,which=3)


###################################################
### code chunk number 11: pp1m3
###################################################
   plotProb(mod.mswm,which=1)


###################################################
### code chunk number 12: pp2m3
###################################################
   plotProb(mod.mswm,which=2)


###################################################
### code chunk number 13: pp3m3
###################################################
   plotReg(mod.mswm,expl="x")


###################################################
### code chunk number 14: examples.rnw:156-158
###################################################
data(traffic)
plot(ts(traffic[2:4]),main="Traffic")


###################################################
### code chunk number 15: examples.rnw:165-167
###################################################
model=glm(NDead~Temp+Prec,traffic,family="poisson")
summary(model)


###################################################
### code chunk number 16: examples.rnw:172-174
###################################################
m1=msmFit(model,k=2,sw=c(TRUE,TRUE,TRUE),family="poisson",control=list(parallel=FALSE))
summary(m1)


###################################################
### code chunk number 17: examples.rnw:177-178
###################################################
intervals(m1)


###################################################
### code chunk number 18: examples.rnw:182-183
###################################################
plot(m1)


###################################################
### code chunk number 19: fig2_3
###################################################
plotDiag(m1,which=2)


###################################################
### code chunk number 20: fig2_4
###################################################
plotDiag(m1,which=3)


###################################################
### code chunk number 21: pp1m1
###################################################
   plotProb(m1,which=2)


