% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UncVol.R
\name{UncVol}
\alias{UncVol}
\alias{UncVol.MSGARCH_SPEC}
\alias{UncVol.MSGARCH_ML_FIT}
\alias{UncVol.MSGARCH_MCMC_FIT}
\title{Unconditional volatility.}
\usage{
UncVol(object, ...)

\method{UncVol}{MSGARCH_SPEC}(object, par = NULL, ctr = list(), ...)

\method{UncVol}{MSGARCH_ML_FIT}(object, ctr = list(), ...)

\method{UncVol}{MSGARCH_MCMC_FIT}(object, ctr = list(), ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{TransMat}.}

\item{par}{Vector (of size d) or matrix (of size \code{n.mcmc} x d) of parameter
estimates where d must have
the same length as the default parameters of the specification.}

\item{ctr}{A list of control parameters:
\itemize{
\item \code{n.sim} (integer >= 0) :
Number indicating the number of simulation done for estimation of the
unconditional volatility. (Default: \code{n.sim = 250L})
\item \code{n.ahead} (integer >= 0) :
Number indicating the number of step ahead performs to estimate the
unconditional volatility .(Default: \code{n.ahead = 5000L})
\item \code{n.burn} (integer >= 0) :
Number indicating the number of discarded step ahead to estimate the
unconditional volatility. (Default: \code{n.burn = 1000L})
}}
}
\value{
A \code{scalar} corresponding to the process unconditional volatility.
}
\description{
Method returning the unconditional volatility of the
process in each state and for the overall process..
}
\details{
If a matrix of MCMC posterior draws is given, the
Bayesian unconditional volatility are calculated.
 The unconditional volatility is estimated by first simulating \code{n.sim}
 paths up to \code{n.burn + n.ahead},
 calculating a forecast of the conditional volatility at each step ahead,
 discarding the first \code{n.burn} step ahead conditional volatilities forecasts,
 and computing the mean of the remaining \code{n.ahead - n.burn} conditional
 volatilites forecasts. This method is based on the fact that
 the conditional volatility forecast will converge to the unconditional volatilty
 the further the forecast his from the starting point.
 We take the average as a way to remove the noise that comes with the simulation process.
 Overall, this method allows to compute the unconditional volatilty of arbitrarily complex models.
}
\examples{
# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# compute the unconditional volatility of each regime and the overall process
\dontrun{
  par <- c(0.1, 0.1, 0.8, 0.2, 0.1, 0.8, 0.99, 0.01)
  UncVol(object = spec, par = par)
}
}
