% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht.R
\name{ht}
\alias{ht}
\title{Conditional variance in each regime.}
\usage{
ht(object, theta, y)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}
or fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT}
created with \code{\link{fit.bayes}}.}

\item{theta}{Vector (of size d) or matrix (of size M x d) of parameter estimates (not require when using a fit object).}

\item{y}{Vector (of size T) of observations (not require when using a fit object).}
}
\value{
Condititional variance (array of size (T + 1) x M x K) in each regime.
}
\description{
Method returning the conditional variance of each regime.
}
\details{
If a matrix of parameter estimates is given, each parameter estimates is evaluated individually.
}
\examples{
# load data
data("sp500")
sp500 = sp500[1:1000]

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with ML estimation using DEoptim intialization
set.seed(123)
fit = MSGARCH::fit.mle(spec = spec, y = sp500)

# Compute the conditional variance
ht = MSGARCH::ht(object = fit)

plot(ht)
}

