% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiMSE_internal.R
\name{HistMICE}
\alias{HistMICE}
\title{Reconstruct historical dynamics}
\usage{
HistMICE(
  x,
  StockPars,
  FleetPars,
  np,
  nf,
  nareas,
  maxage,
  nyears,
  N,
  VF,
  FretA,
  maxF = 0.9,
  MPA,
  Rel,
  SexPars,
  qs,
  qfrac,
  plusgroup
)
}
\arguments{
\item{x}{Integer, the simulation number}

\item{StockPars}{A list of sampled stock parameters, one list element per stock}

\item{FleetPars}{A hierarchical list of sampled fleet parameters, first list level is stock, second is fleet}

\item{np}{The number of stocks}

\item{nf}{The number of fleets}

\item{nareas}{The number of areas}

\item{maxage}{The maximum number of modeled ages}

\item{nyears}{The number of historical 'spool-up' years (from unfished to now)}

\item{N}{An array of stock numbers \verb{[nsim,np,maxage,nyears,nareas]} - only the values from the first year are used}

\item{VF}{An array of vulnerability \verb{[nsim,np,nf,maxage,nyears+proyears]}}

\item{FretA}{An array of retention \verb{[nsim,np,nf,maxage,nyears+proyears]}}

\item{maxF}{A numeric value specifying the maximum fishing mortality for any single age class}

\item{MPA}{An of spatial closures by year \verb{[np,nf,nyears+proyears,nareas]}}

\item{Rel}{A list of inter-stock relationships see slot Rel of MOM object class}

\item{SexPars}{A list of sex-specific relationships (SSBfrom, stock_age)}

\item{qs}{Vector of q values}

\item{qfrac}{Array of qfrac}

\item{plusgroup}{Plusgroup}
}
\description{
Function that reconstructs historical stock trends from fitted qs and all other parameters including MICE components
}
\author{
T.Carruthers
}
\keyword{internal}
