% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS2OM.R
\name{optSR}
\alias{optSR}
\title{Wrapper for estimating stock recruitment parameters from resampled stock-recruitment data}
\usage{
optSR(x, SSB, rec, SSBpR, pars, frac = 0.5, plot = FALSE, type = c("BH",
  "Ricker"))
}
\arguments{
\item{x}{position to accommodate lapply-type functions}

\item{SSB}{'observations' of spawning biomass}

\item{rec}{'observations' (model predictions) of recruitment}

\item{SSBpR}{spawning stock biomass per recruit at unfished conditions}

\item{pars}{an initial guess at model parameters steepness and R0}

\item{frac}{the fraction of observations for resampling}

\item{plot}{should a plot of model fit be produced?}

\item{type}{what type of stock recruitment curve is being fitted ("BH" = Beverton-Holt or "Ricker")}
}
\value{
Estimated value of steepness.
}
\description{
Wrapper for estimating stock recruitment parameters from resampled stock-recruitment data
}
\author{
T. Carruthers
}
