% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCRs.R
\name{HCR40_10}
\alias{HCR40_10}
\alias{HCR60_20}
\title{Ramped harvest control rules (40-10 and 60-20)}
\usage{
HCR40_10(Assessment, reps = 1, ...)

HCR60_20(Assessment, reps = 1, ...)
}
\arguments{
\item{Assessment}{An object of class \linkS4class{Assessment} with estimates of
FMSY or UMSY, vulnerable biomass, and spawning biomass depletion in terminal year.}

\item{reps}{The number of stochastic samples of the TAC recommendation.}

\item{...}{Miscellaneous arguments (not currently used).}
}
\value{
An object of class \linkS4class{Rec} with the TAC recommendation.
}
\description{
A output control rule with a ramp that reduces the TAC recommendation
(FMSY * Vulnerable biomass) when spawning biomass depletion (SSB/SSB0) is less than
the target reference point (TRP). The TAC reduction is linearly reduced to 0
when depletion is less than the limit reference point (LRP). For example,
TRP is 0.4 and LRP is 0.1 in the 40-10 control rule.
}
\section{Functions}{
\itemize{
\item \code{HCR40_10}: Common U.S. west coast control rule.

\item \code{HCR60_20}: More conservative than 40-10
}}

\note{
Function will use slot \code{B_B0} of the Asssessment object (e.g. for surplus
production models \link{SP} and \link{SP_SS}) if \code{SSB_SSB0} is unavailable.
}
\examples{
# 40-10 linear ramp
Brel <- seq(0, 1, length.out = 200)
plot(Brel, HCRlin(Brel, 0.1, 0.4), xlab = "Estimated SSB/SSB0",
ylab = "TAC adjustment factor", main = "40-10 harvest control rule",
type = "l", col = "blue")
abline(v = c(0.1, 0.4), col = "red", lty = 2)

# create an MP to run in closed-loop MSE
DD_40_10 <- make_MP(DD_TMB, HCR40_10)

\dontrun{
myOM <- DLMtool::runMSE(DLMtool::testOM, MPs = c("FMSYref", "DD_40_10"))
}

# 60-20 linear ramp
Brel <- seq(0, 1, length.out = 200)
plot(Brel, HCRlin(Brel, 0.2, 0.6), xlab = "Estimated SSB/SSB0",
ylab = "TAC adjustment", main = "60-20 harvest control rule", type = 'l',
col = 'blue')
abline(v = c(0.2, 0.6), col = "red", lty = 2)

# create an MP to run in closed-loop MSE
DD_60_20 <- make_MP(DD_TMB, HCR60_20)

}
\references{
Punt, A. E, Dorn, M. W., and Haltuch, M. A. 2008. Evaluation of threshold management strategies
for groundfish off the U.S. West Coast. Fisheries Research 94:251-266.
}
\seealso{
\link{HCR60_20} \link{HCRlin} \link{make_MP}
}
\author{
Q. Huynh & T. Carruthers
}
