% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotTree.R
\name{plotTree}
\alias{plotTree}
\title{Plot nodes of the representative tree}
\usage{
plotTree(ans, type = "prob", group = 1, legend = FALSE, main = "",
  node.size = 5)
}
\arguments{
\item{ans}{A \code{mrs} object.}

\item{type}{What is represented at each node.
The options are \code{type = c("eff", "prob")}.}

\item{group}{If \code{type = "eff"}, which group effect size is used.}

\item{legend}{Color legend for type. Default is \code{legend = FALSE}.}

\item{main}{Main title. Default is \code{main = ""}.}

\item{node.size}{Size of the nodes. Default is \code{node.size = 5}.}
}
\description{
This function visualizes the representative tree of the output of the \code{\link{mrs}} function.
For each node of the representative tree, the posterior probability of difference (PMAP) or the effect size is plotted.
Each node in the tree is associated to a region of the sample space.
All non-terminal nodes have two children nodes obtained by partitiing the parent region with a dyadic cut along a given direction.
The numbers under the vertices represent the cutting direction.
}
\note{
The package \pkg{igraph} is required.
}
\examples{
set.seed(1)
p = 2
n1 = 200
n2 = 200
mu1 = matrix( c(9,9,0,4,-2,-10,3,6,6,-10), nrow = 5, byrow=TRUE)
mu2 = mu1; mu2[2,] = mu1[2,] + 1

Z1 = sample(5, n1, replace=TRUE)
Z2 = sample(5, n2, replace=TRUE)
X1 = mu1[Z1,] + matrix(rnorm(n1*p), ncol=p)
X2 = mu2[Z2,] + matrix(rnorm(n2*p), ncol=p)
X = rbind(X1, X2)
colnames(X) = c(1,2)
G = c(rep(1, n1), rep(2,n2))

ans = mrs(X, G, K=8)
plotTree(ans, type = "prob", legend = TRUE)
}
\references{
Soriano J. and Ma L. (2014). Multi-resolution two-sample comparison
through the divide-merge Markov tree. \emph{Preprint}.
 \url{http://arxiv.org/abs/1404.3753}
}

