% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearModelTraining.R
\name{linearModelTraining}
\alias{linearModelTraining}
\title{linearModelTraining}
\usage{
linearModelTraining(
  DataT,
  insigThs = 1e-08,
  alpha = 0.05,
  messageFlag = FALSE,
  polyDegree = 1,
  expFlag = FALSE
)
}
\arguments{
\item{DataT}{contains a multiresolution dataset s.t.
\code{DataT$X[i,d]} is a value of feature \code{d} of individual \code{i},
\code{DataT$Y[i]} is value of target variable of individual \code{i} that we want to fit \code{DataT$Y ~ DataT$X} in linear model, and
\code{clsLayer[i,j]} is a cluster ID of individual \code{i} at layer \code{j}; \code{clsLayer[i,1]} is the first layer that everyone typically belongs to a single cluster.}

\item{insigThs}{is a threshold to determine whether a magnitude of a feature coefficient is enough so that the feature is designated as a selected feature.}

\item{alpha}{is a significance level to determine whether a magnitude of a feature coefficient is enough so that the feature is designated as a selected feature.}

\item{messageFlag}{is a flag. If it is true, the function shows the text regarding the progress of computing.}

\item{polyDegree}{is a degree of polynomial function that is used to fit the data.
If it is greater than 1, the polynomial formula is used in \code{lm()} instead of \code{"y=."}.}

\item{expFlag}{is an exponential flag to control the formula for data fitting.
If it is true, then the exp() formula is used in \code{lm()} instead of \code{"y=."}.}
}
\value{
This function returns \code{models} and \code{DataT}.

\item{ \code{models[[j]][[k]]} }{ is a linear model of a cluster ID \code{k} at the layer \code{j}.
The \code{models[[j]][[k]]$selFeatureSet} represents a set of selected-feature indices of the model where the feature index 1 is the intercept,
and the feature index \code{d} is the (d-1)th variable \code{DataT$X[,d-1]}. }
\item{ DataT }{ is a \code{DataT} with \code{DataT$nNodes}, which is a number of total models from all layers. }
}
\description{
linearModelTraining is a support function for training linear models for partitions in all layers.
}
\examples{
# Running linearModelTraining using simulation data
DataT<-SimpleSimulation(100,type=1)
obj<-linearModelTraining(DataT)

}
