% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.dep.t.avg.R
\name{d.dep.t.avg}
\alias{d.dep.t.avg}
\title{d for Dependent t with Average SD Denominator}
\usage{
d.dep.t.avg(m1, m2, sd1, sd2, n, a = 0.05)
}
\arguments{
\item{m1}{mean from first level}

\item{m2}{mean from second level}

\item{sd1}{standard deviation from first level}

\item{sd2}{standard deviation from second level}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
The effect size (Cohen's d) with associated confidence intervals,
the confidence intervals associated with the means of each group,
standard deviations of the means for each group.

\item{d}{effect size}
\item{dlow}{lower level confidence interval d value}
\item{dhigh}{upper level confidence interval d value}
\item{M1/M2}{mean one and two}
\item{M1low/M2low}{lower level confidence interval of mean one or two}
\item{M1high/M2high}{upper level confidence interval of mean one or two}
\item{sd1/sd2}{standard deviation of mean one and two}
\item{se1/se2}{standard error of mean one and two}
\item{n}{sample size}
\item{df}{degrees of freedom (sample size - 1)}
\item{estimate}{the d statistic and confidence interval in APA style for markdown printing}
}
\description{
This function displays d and the non-central confidence interval
for repeated measures data, using the average standard deviation of
each level as the denominator.
}
\details{
To calculate d, mean two is subtracted from mean one, which is then
divided by the average standard deviation.

d_av = (m1 - m2) / ((sd1 + sd2) / 2)

\href{https://www.aggieerin.com/shiny-server/tests/deptavgm.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "dept_data" dataset included
#in the MOTE library.

#In a study to test the effects of science fiction movies on people's
#belief in the supernatural, seven people completed a measure of belief
#in the supernatural before and after watching a popular science fiction
#movie. Higher scores indicated higher levels of belief.

    t.test(dept_data$before, dept_data$after, paired = TRUE)

#You can type in the numbers directly, or refer to the dataset,
#as shown below.

    d.dep.t.avg(m1 = 5.57, m2 = 4.43, sd1 = 1.99,
                sd2 = 2.88, n = 7, a = .05)

    d.dep.t.avg(5.57, 4.43, 1.99, 2.88, 7, .05)

    d.dep.t.avg(mean(dept_data$before), mean(dept_data$after),
                sd(dept_data$before), sd(dept_data$after),
                length(dept_data$before), .05)

#The mean measure of belief on the pretest was 5.57, with a standard
#deviation of 1.99. The posttest scores appeared lower (M = 4.43, SD = 2.88)
#but the dependent t-test was not significant using alpha = .05,
#t(7) = 1.43, p = .203, d_av = 0.47. The effect size was a medium effect suggesting
#that the movie may have influenced belief in the supernatural.
}
\keyword{average,}
\keyword{cohen's}
\keyword{d}
\keyword{d,}
\keyword{dependent}
\keyword{effect}
\keyword{measures}
\keyword{paired-sample,}
\keyword{repeated}
\keyword{size,}
\keyword{t-test,}
