% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.values.G.R
\name{criteria.values.G}
\alias{criteria.values.G}
\title{Evaluating individual criteria of the designs, from the Generalized compound criteria \insertCite{Goos2005model,Olga2017}{MOODE}}
\usage{
criteria.values.G(search.obj, mood.obj, eps = 10^-23)
}
\arguments{
\item{search.obj}{Output of the `Search' function}

\item{mood.obj}{Output of the `mood' function}

\item{eps}{Computational tolerance, default 10^-20}
}
\value{
List of the calculated values:
\itemize{
\item \code{df} pure error degrees of freedom
\item \code{Ds} Ds-criterion value, intercept excluded
\item \code{DP} DPs-criterion value, intercept excluded
\item \code{LoFD} LoF(D)-criterion value from the GD-criterion
\item \code{LoFDP} LoF(DP)-criterion value from the GDP-criterion
\item \code{biasD} bias(D)-criterion value from the GD-criterion
\item \code{Ls} Ls-criterion value, intercept excluded
\item \code{LP} LPs-criterion value, intercept excluded
\item \code{LoFL} LoF(L)-criterion value from the GL-criterion
\item \code{LoFLP} LoF(LP)-criterion value from the GLP-criterion
\item \code{biasL} bias(L)-criterion value from the GL-criterion
}
}
\description{
Calculating values of determinant- and trace-based components of
Generalized D-, DP-, L- and LP- criteria for an output of a search object,
with model and control parameters set in a mood object.
}
\references{
\insertAllCited
}
