% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_get_prodlayers.R
\name{MODIStsp_get_prodlayers}
\alias{MODIStsp_get_prodlayers}
\title{Retrieve the names of MODIS layers for a product}
\usage{
MODIStsp_get_prodlayers(prodname)
}
\arguments{
\item{prodname}{character containing the code of the desired MODIS product.
NOTE: for products available separately for Terra and Aqua (e.g., MOD13Q1/MYD13Q1),
use the code M\emph{D_code_ (e.g., M}D13Q1)}
}
\value{
list, containing the slots: \code{prodname}, \code{bandnames}, \code{quality_bandnames} and
\code{indexes_bandnames}, \code{band_fullnames}, \code{quality_fullnames}, \code{indexes_fullnames}
}
\description{
Function used to retrieve the names of original MODIS layers, quality layers
and eventually available spectral indexes given a MODIS product code.
It is useful to identify the names of the layers to be processed when
launching MODIStsp from the CLI.
}
\note{
License: GPL 3.0
}
\examples{

# Get layers of product M*13Q1 based on code
MODIStsp_get_prodlayers("M*13Q1")

# Get layers of product M*13Q1 based on full name
MODIStsp_get_prodlayers("Vegetation Indexes_16Days_250m (M*D13Q1)")

# Get indexes names of product M*13Q1 based on full name
MODIStsp_get_prodlayers("MCD43C4")$indexes_bandnames


}
\author{
Lorenzo Busetto, phD (2014-2020)
}
