% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reqbands.R
\name{get_reqbands}
\alias{get_reqbands}
\title{Identify the MODIS original bands needed for a given processing run}
\usage{
get_reqbands(
  bands_indexes_matrix,
  indexes_bandsel,
  indexes_bandnames,
  quality_bandsel,
  quality_bandnames,
  out_prod_folder,
  file_prefix,
  yy,
  DOY,
  out_format,
  reprocess
)
}
\arguments{
\item{bands_indexes_matrix}{\code{matrix} built by \code{set_bandind_matrix}}

\item{indexes_bandsel}{\verb{character array}Spectral Indexes to be computed starting from reflectance bands.
You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$indexes_bandnames),
Default: NULL}

\item{indexes_bandnames}{names of all indexes available for the product being processed}

\item{quality_bandsel}{\verb{character array} Quality Indicators to be computed starting from
bit fields of original MODIS layers. You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$quality_bandnames),
Default: NULL}

\item{quality_bandnames}{names of all quality indicators available for the product being processed}

\item{out_prod_folder}{\code{character} Main folder where the MODIStsp processed
raster will be stored. Used to check if a given processed image already exists.}

\item{file_prefix}{File prefix corresponding to the MODIS product being
processed. Used to check if a given processed image already exists.}

\item{yy}{Year corresponding to the image being processed. Used to check if
a given processed image already exists.}

\item{DOY}{DOY corresponding to the image being processed. Used to check if
a given processed image already exists.. Used to check if a given processed image already exists.}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Desired output format.}

\item{reprocess}{\code{logical} If TRUE, reprocess data for already existing dates.}
}
\value{
req_bands_indexes
}
\description{
Helper function used in MODIStsp_process to identify which
MODIS hdf layers are required for the current process. The required layers
include all MODIS original layers selected by the user, plus all those
required to compute the Spectral Indexes and Quality Indicators selected
by the user
}
\author{
Lorenzo Busetto, phD (2017) \href{mailto:lbusett@gmail.com}{lbusett@gmail.com}
}
