% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_process.R
\name{MODIStsp_process}
\alias{MODIStsp_process}
\title{MODIStsp main processing function}
\usage{
MODIStsp_process(proc_opts, n_retries, verbose = TRUE)
}
\arguments{
\item{proc_opts}{\code{data.frame} containing all processing parameters, as
passed from the MODIStsp GUI, or created in \code{MODIStsp} by joining
explicitly passed arguments with a (not mandatory) options file.}

\item{n_retries}{\code{numeric} maximum number of retries on download functions.
In case any download function fails more than \code{n_retries} times consecutively,
MODIStsp_process will abort, Default: 20}

\item{verbose}{\code{logical} If FALSE, suppress processing messages, Default: TRUE}
}
\value{
The function is called for its side effects.
}
\description{
Main processing function of MODIStsp. Takes as input processing
parameters specified by the user and performs all required processing.
}
\details{
After retrieving the input processing options, the function
\enumerate{
\item Accesses NASA http archive to determine the list of files to be
downloaded/processed (or, in case of offline processing, get the list
of already available hdf files present in \code{out_mod_folder});
\item Performs all required processing steps on each date (download,
reprojection, resize, mosaicing, Spectral Indexes and Quality indicators
computation);
\item Creates virtual files of the processed time series.
}

Reprojection and resize is dealt with by accessing gdal routines through the
\href{https://CRAN.R-project.org/package=gdalUtilities}{\code{gdalUtilities}}
package.
Extraction of bitfields from Quality layers is done though bitwise computation
Checks are done in order to not re-download already existing HDF images, and not
reprocess already processed dates (if the user did not specify that)
}
\note{
Thanks Tomislav Hengl and Babak Naimi, whose scripts made the starting point for
development of this function (\href{http://r-gis.net/?q=ModisDownload}{ModisDownload};
\href{http://spatial-analyst.net/wiki/index.php?title=Download_and_resampling_of_MODIS_images}{Download_and_resampling_of_MODIS_images})

License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
