% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_opts.R
\name{load_opts}
\alias{load_opts}
\title{Load MODIStsp processing options from a JSON file}
\usage{
load_opts(opts_jsfile)
}
\arguments{
\item{opts_jsfile}{Expected file name of the JSON file containing
processing options}
}
\value{
\verb{data frame} general_opts, containing the processing options
retrieved from the JSON file (or the defaults set at first execution).
See also \code{MODIStsp_GUI} and \code{MODIStsp_process}
}
\description{
Load MODIStsp processing option from \code{opts_jsfile} if
it already exist, otherwise initialize processing options to default and
save them to \code{opts_jsfile} (typically done at first execution, or if the
MODIStsp_previous.json is deleted). Sends warnings if options file is from an
old version. Aborts if the json file is not a valid MODIStsp options file
}
\note{
License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
