% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp.R
\name{MODIStsp}
\alias{MODIStsp}
\title{MODIStsp main function}
\usage{
MODIStsp(gui = TRUE, options_file = NULL, spatial_file_path = NULL,
  scroll_window = FALSE, test = NULL, n_retries = 20,
  verbose = TRUE)
}
\arguments{
\item{gui}{\code{logical} if TRUE: the GUI is opened before processing. If FALSE:
processing parameters are retrieved from the provided \code{options_file}
argument), Default: TRUE}

\item{options_file}{\code{character} full path to a JSON file
containing MODIStsp processing options saved from the GUI. If NULL,
parameters of the last successful run are retrieved from file
"MODIStsp_Previous.json" in subfolder "Previous"), Default: NULL}

\item{spatial_file_path}{\code{character} (optional) full path of a spatial file
to use to derive the processing extent. If not NULL, the processing options
which define the extent, the selected tiles and the "Full Tile / Custom"
in the JSON options file are overwritten and new files are created on the
extent of the provided spatial file, Default: NULL}

\item{scroll_window}{\code{logical} if TRUE, the GUI window is opened
fullscreen with scrollbars (this is useful on devices with small displays).
If using a device with a display resolution >= 1024x768, leaving this
parameter to FALSE is suggested, Default: FALSE}

\item{test}{\code{integer | character  (e.g., "01a")} if set, MODIStsp is executed in
"test mode", using a preset Options File instead than opening the GUI or accepting the
\code{options_file} parameter. This allows both to check correct installation on
user's machines, and to implement unit testing.}

\item{n_retries}{\code{numeric} maximum number of retries on download functions.
In case any download function fails more than \code{n_retries} times consecutively,
MODIStsp_process will abort, Default: 20}

\item{verbose}{\code{logical} If FALSE, suppress processing messages,
Default: TRUE}
}
\description{
Main function for the MODIS Time Series Processing Tool
(MODIStsp)
}
\details{
The function is used to:
\itemize{
\item initialize the processing (folder names, packages, etc.);
\item launch the GUI (\code{\link[=MODIStsp_GUI]{MODIStsp_GUI()}}) and receive its outputs on interactive
execution, or load an options file on non-interactive execution;
\item launch the routines for downloading and processing the requested datasets.
(\code{\link[=MODIStsp_process]{MODIStsp_process()}})
}
}
\note{
License: GPL 3.0
}
\examples{

\dontrun{
#' # - Running the tool using the GUI

# Running the tool without any option will start the GUI with the default or
# last used settings, in interactive mode (i.e., with gui = TRUE).

MODIStsp()
}

\dontrun{

#' # - Running the tool using the settings previously saved in a specific options file

# **NOTE** Output files of examples are saved to file.path(tempdir(), "MODIStsp").
# You can run the examples with `gui = TRUE` to set a different output folder!

# Here we use a test json file saved in MODIStsp installation folder which
# downloads and processed 3 MOD13A2 images over the Como Lake (Lombardy, Italy)
# and retrieves NDVI and EVI data, plus the Usefulness Index Quality Indicator.

options_file <- system.file("testdata/test_MOD13A2.json", package = "MODIStsp")
MODIStsp(gui = FALSE, options_file = options_file, verbose = TRUE)
}

\dontrun{

# Running the tool using the settings previously saved in a specific option file
# and specifying the extent from a spatial file allows to re-use the same
# processing settings to perform download and reprocessing on a different area

options_file <- system.file("testdata/test_MOD13A2.json", package = "MODIStsp")
spatial_file <- system.file("testdata/lakeshapes/garda_lake.shp", package = "MODIStsp")
MODIStsp(gui = FALSE, options_file = options_file,
  spatial_file_path = spatial_file, verbose = TRUE)
}

\dontrun{

# Running the tool using the settings previously saved in a
# specific options file and specifying each time the extent from a different
# spatial file (e.g., to perform the same processing on several extents)

extent_list  <- c(system.file("testdata/lakeshapes/garda_lake.shp",
                              package = "MODIStsp"),
                  system.file("testdata/lakeshapes/iseo_lake.shp",
                              package = "MODIStsp"))
extent_list

# Note that you can also put all your extent files in a specific folder and
# create the extent list using for example.
# extent_list = list.files(system.file("testdata/lakeshapes/", package = "MODIStsp"),
#                          full.names = TRUE, "\\\\.shp$")

options_file <- system.file("testdata/test_MOD13A2.json", package = "MODIStsp")
for (single_shape in extent_list) {
  MODIStsp(gui = FALSE, options_file = options_file,
           spatial_file_path = single_shape, verbose = TRUE)
}

# output files are placed in separate folders:
outfiles_garda <- list.files(file.path(tempdir(), "MODIStsp/garda_lake/VI_16Days_1Km_v6/EVI"),
           full.names = TRUE)
outfiles_garda

library(raster)
plot(raster(outfiles_garda[1] ))

outfiles_iseo <- list.files(file.path(tempdir(), "MODIStsp/iseo_lake/VI_16Days_1Km_v6/EVI"),
           full.names = TRUE)
outfiles_iseo

plot(raster(outfiles_iseo[1]))

# See also http://ropensci.github.io/MODIStsp/articles/noninteractive_execution.html
}
}
\seealso{
\code{\link[=MODIStsp_GUI]{MODIStsp_GUI()}}, \code{\link[=MODIStsp_process]{MODIStsp_process()}}
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2015-2017) \email{ranghetti.l@irea.cnr.it}
}
