% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{fit.MNB}
\alias{fit.MNB}
\title{Maximum likelihood estimation}
\usage{
fit.MNB(star, formula, dataSet, tab = TRUE)
}
\arguments{
\item{star}{Initial values for the parameters to be optimized over.}

\item{formula}{The structure matrix of covariates of dimension n x p (in models that include an intercept x
should contain a column of ones).}

\item{dataSet}{data}

\item{tab}{Logical. Print a summary of the coefficients,
standard errors and p-value for class "MNB".}
}
\value{
Returns a list of summary statistics
of the fitted multivariate negative binomial model.
}
\description{
Estimate parameters by quasi-Newton algorithms.
}
\details{
Method "BFGS" is a quasi-Newton method, specifically that published
simultaneously in 1970 by Broyden, Fletcher, Goldfarb and Shanno. This uses function
values and gradients to build up a picture of the surface to be optimized.
}
\examples{

\donttest{

data(seizures)
head(seizures)

star <-list(phi=1, beta0=1, beta1=1, beta2=1, beta3=1)

mod1 <- fit.MNB(formula=Y ~ trt + period +
trt:period + offset(log(weeks)), star=star, dataSet=seizures)

mod1

seizures49 <- seizures[-c(241,242,243,244,245),]

mod2 <- fit.MNB(formula=Y ~ trt + period +
trt:period + offset(log(weeks)), star=star, dataSet=seizures49)

mod2

}

}
\references{
\itemize{
\item Fabio, L., Paula, G. A., and de Castro, M. (2012). A Poisson mixed model
with nonormal random effect distribution. Computational Statistics and
Data Analysis, 56, 1499-1510.
\item Fabio, L. C., Villegas, C., Carrasco, J. M. F., and de Castro, M. (2021). D
Diagnostic tools for a multivariate negative binomial model for fitting correlated data with
overdispersion. Communications in Statistics - Theory and Methods.
https://doi.org/10.1080/03610926.2021.1939380.
}
}
\author{
Jalmar M F Carrasco <carrascojalmar@gmail.com>,
Cristian M Villegas Lobos <master.villegas@gmail.com> and Lizandra C Fabio <lizandrafabio@gmail.com>
}
