% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMeM_reml.R
\name{MMeM_reml}
\alias{MMeM_reml}
\title{Multivariate REML Method}
\usage{
MMeM_reml(fml, data, factor_X, T.start, E.start, maxit = 50,
  tol = 1e-09)
}
\arguments{
\item{fml}{a two-sided linear formula object describing both the fixed-effects and random-effects  parts  of  the  model,
 with  the  response  on  the  left  of  a ~ operator. For univariate response, put variable name directly; for multivariate responses
 combine variables using concatenate operator, for example, for bivariate responses, c(var1, var2).  The predictor terms are separated  by + operators,  on  the  right.   Random-effects  terms  are
distinguished by vertical bars '|' separating expressions for design matrices from grouping factors.}

\item{data}{data frame containing the variables named in formula.}

\item{factor_X}{(logical) indicating whether predictor is a factor or continuous. By default is TRUE}

\item{T.start}{the starting matrix for the variance covariance matrix of the block random effects, it has to be positive definite q by q symmetric matrix.}

\item{E.start}{the starting matrix for the variance covariance matrix of the block random effects, it has to be positive definite q by q symmetric matrix.}

\item{maxit}{the maximum number of iterations}

\item{tol}{the convergence tolerance}
}
\value{
The function returns a list with the following objects:
\itemize{
\item \code{T.estimates} is the estimated variance covariance components of the variance covariance matrix of the block random effects
\item \code{E.estimates} is the estimated variance covariance components of the variance covariance matrix of the residuals
\item \code{VCOV} is the asymptotic
dispersion matrix of the estimated variance covariance components for the block random effects and the residuals.
}
}
\description{
Estimating the variance components under the multivariate mixed effects model using REML methods
}
\details{
Suppose n observational units, q variates, p fixed effects coefficients and s random effects units.
The model supports multivariate mixed effects model for one-way randomized block design with equal design matrices:
\deqn{Y = XB + ZU + E}
where Y is n by q response variates matrix;
X is n by p design matrix for the fixed effects;
B is p by q coefficients matrix for the fixed effects;
Z is n by s design matrix for the random effects;
U is s by q matrix for the random effects;
E is n by q random errors matrix.

The model also supports simple OLS multivariate regression:
\deqn{y = Xb + Zu + e}
where y is n by 1 response vector;
b is p by 1 coefficients vector for the fixed effects;
u is s by 1 matrix for the random effects.
}
\examples{

data(simdata)
T.start <- matrix(c(10,5,5,15),2,2)
E.start <- matrix(c(10,1,1,3),2,2)
results_reml <- MMeM_reml(fml = c(V1,V2) ~ X_vec + (1|Z_vec), data = simdata,
factor_X = TRUE, T.start = T.start, E.start = E.start, maxit = 10)


}
\references{
Meyer, K. "Maximum likelihood estimation of variance components for a multivariate mixed model with equal design matrices." Biometrics 1985: 153,165.
}
