% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataDesc.R
\docType{data}
\name{kidney}
\alias{kidney}
\title{Kidney Infection Data}
\format{
An object of class \code{data.frame} with 76 rows and 7 columns.
}
\usage{
kidney
}
\value{
Kidney infection data contains the following fields:
\item{patient}{id}
\item{time}{time}
\item{status}{event status}
\item{age}{in years}
\item{sex}{1=male, 2=female}
\item{disease}{disease type (0=GN, 1=AN, 2=PKD, 3=Other)}
\item{frail}{frailty estimate from original paper}
}
\description{
The data consisted of the time to first and second infection relapse in 38 kidney disease patients using a portable dialysis machine.
Infection may occur where the catheter was inserted. Catheters are subsequently removed if infection develops and may be removed for other reasons,
in which case observations are censored.
}
\examples{
data = data(Kidney)
}
\references{
McGilchrist C.A. and Aisbett C.W.(1991). "Regression with frailty in survival analysis." \emph{Biometrics} \strong{47}, 461-466.
}
\keyword{datasets}
