% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTNMM.R
\name{LTNMM}
\alias{LTNMM}
\title{MM algorithm based on the AD method for left-truncated normal distribution}
\usage{
LTNMM(
  formula,
  a,
  mu = NULL,
  sigma = NULL,
  data = sys.frame(sys.parent()),
  Maxiter = 2000,
  convergence = 1e-06,
  ...
)
}
\arguments{
\item{formula}{A formula object which symbolically describes the model to calculated.}

\item{a}{A numeric scalar of the known left truncation value.}

\item{mu}{The mean of the normal distribution is set to NULL by default. If the distribution is truncated, we use estimates from OLS.}

\item{sigma}{The variance of the normal distribution is set to NULL by default. If the distribution is truncated, we use estimates from OLS.}

\item{data}{List that contains corresponding covariates. If none is provided then assumes objects are in user’s environment.}

\item{Maxiter}{The maximum number of iterations is specified by default as 2000.}

\item{convergence}{Specify the convergence criterion, the default is 1e-6.}

\item{...}{Additional arguments}
}
\value{
An object of class \code{LTNMM} that contains the following fields: total amount of observations,
the number of iterations, convergence rate, the log likelihood value, estimated results for the unknown parameters,
the standard deviation of estimate for the unknown parameters, the likelihood-based 95\% confidence interval for the unknown parameters,
information criterion: AIC value and BIC value.
}
\description{
The \code{LTNMM} function is used to calculate a left-truncated normal distribution model. A \eqn{ LTN(\mu, \sigma^2; a) } has the density function

\deqn{f(y; \mu, \sigma^2; a) = \frac{1}{c \sqrt{2 \pi \sigma^{2}}} \exp{( -\frac{(y-\mu)^{2}}{2 \sigma^{2}} )} \centerdot I(y \geq a) }

where \eqn{(\mu, \sigma^2)} are two unknown parameters, \eqn{ a } is a known constant, \eqn{ c = 1- \Phi(\frac{a-u}{ \sigma}) }, and  \eqn{ \Phi(\centerdot) } is the cdf of the standard normal distribution.
}
\details{
The \code{LTNMM} function is used to calculate a left-truncated normal distribution model using MM algorithms based on AD technology.
The \code{formula} parameter can be used to provide the data that needs to be calculated, such as \code{formula=y~1}. By default, the
\code{data} is provided by the user’s environment. The initial values of the mean and variance of the normal distribution are estimated using OLS.
}
\examples{
y=c(8.7, 5.4, 8.9, 5.8, 6.2, 9.9, 7.5, 9.5, 6.5, 6.3); a=5
LTNMM(y~1, a=5)

}
\references{
Tian G.L., Huang X.F., and Xu, J.(2019). 'An assembly and decomposition approach for constructing separable minorizing functions in a class of MM algorithms.' \emph{Statistica Sinica} \strong{29}(2), 961-982.
}
