\name{runstate}
\alias{runstate}
\title{Detect State of a Run Using File Existance Criteria}
\description{
	In real time, determines the status of a run generated by \code{NONR}.
}
\usage{
runstate(
	run,
	project=getwd(),
	rundir=file.path(project,run),
	testfile=c('FCON','FILE10','OUTPUT'),
	queued=   c(0,0,0),
	compiled= c(1,0,0),
	running=  c(1,1,1),
	done=     c(1,0,1),
	...
)
}
\arguments{
  \item{run}{a run name or number (scalar)}
  \item{project}{path to the directory containing run subdirectories}
  \item{rundir}{the path to the run directory}
  \item{testfile}{vector of filenames possibly present in \code{rundir}}
  \item{queued}{logical vector (or coercible); see details}
  \item{compiled}{logical vector (or coercible); see details}
  \item{running}{logical vector (or coercible); see details}
  \item{done}{logical vector (or coercible); see details}
  \item{\dots}{ignored}
}

\details{
	The status of a run is either queued, compiled, running, done, or indeterminate.
	The last occurs if the run directory does not exist.  It also occurs if 
	the more than one or fewer than one of the other states is detected.
	\code{queued}, \code{compiled}, \code{running}, and \code{done} must have 
	the same length as \code{testfile} and must be coercible to \code{logical}.
	They indicate the subset of \code{testfile} that is present in \code{rundir}
	when that state applies. Obviously, they should be different from eachother.
	
	\code{runstate} only analyzes one run at a time, but can be easily wrapped
	in \code{sapply}.
	
	The defaults for \code{testfile} are defined by NONMEM.  FCON: nm/ABLOCK.f.
	FILE10: nm/BLKDAT.f.  OUTPUT: nm/BEGIN.f
 }
\value{
	scalar character: one of \sQuote{queued}, \sQuote{compiled}, \sQuote{running}, 
	\sQuote{done}, or \sQuote{indeterminate}.
}
\references{\url{http://mifuns.googlecode.com}}
\author{Tim Bergsma.}
\seealso{
	\itemize{
		\item{}{\code{\link{rlog}}}
	}
}
\examples{
runstate(1)
}
\keyword{manip}
