% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilson.R
\name{mi_wald_phat}
\alias{mi_wald_phat}
\title{Calculates the MI-Wald interval if given a vector of observed
binomial proportions (one for each imputed data frame)}
\usage{
mi_wald_phat(phats, n, ci_level = 0.95, summaries = TRUE)
}
\arguments{
\item{phats}{vector of binomial proportions (one for each imputation)}

\item{n}{the common number of observations over the imputed dataframes}

\item{ci_level}{desired confidence interval level (default 95\%)}

\item{summaries}{boolean: should summary helper values be printed (default TRUE)}
}
\value{
Two-length vector of Wilson lower CI and upper CI
}
\description{
Calculates the MI-Wald interval if given a vector of observed
binomial proportions (one for each imputed data frame)
}
\section{Related Functions}{


\itemize{
\item \code{\link{mi_wald}}
\item \code{\link{mi_wilson_phat}}
}
}

\examples{
phats = c(0.2, 0.23, 0.25)
mi_wald_phat(phats, 100, 0.99, TRUE)

}
