% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/miivs.R
\name{miivs}
\alias{miivs}
\title{Model-implied instrumental variable (MIIV) search}
\usage{
miivs(model)
}
\arguments{
\item{model}{A model specified using lavaan model syntax. See the \code{model} argument within the \code{\link[lavaan]{lavaanify}} function for more information.}
}
\value{
eqns

modeqns
}
\description{
A key step in the MIIV-2SLS approach is to transform the SEM by replacing the latent variables with their scaling indicators minus their errors.  Upon substitution the SEM is transformed from a model with latent variables to one in observed variables with composite errors.  The miivs function automatically makes this transformation.
}
\details{
\itemize{
 \item \code{LHS} The "dependent" variable.
 \item \code{RHS} The right hand side variables of the transformed equation.
 \item \code{Composite Disturbance}  Elements of the composite errors in the transformed equation.
 \item \code{MIIVs} The model implied instrumental variables for each equation.
}
}
\examples{
bollen1989a_model <- '

   Eta1 =~ y1 + y2  + y3  + y4
   Eta2 =~ y5 + y6  + y7  + y8
   Xi1  =~ x1 + x2 + x3

   Eta1 ~ Xi1
   Eta2 ~ Xi1
   Eta2 ~ Eta1

   y1   ~~ y5
   y2   ~~ y4
   y2   ~~ y6
   y3   ~~ y7
   y4   ~~ y8
   y6   ~~ y8
 '

 miivs(bollen1989a_model)
}
\references{
Bollen,	K. A. and	D. J.	Bauer.	2004.	Automating	the	Selection	of
	Model-Implied	Instrumental	Variables.	\emph{Sociological	Methods	and
	Research}, 32, 425-52.

	Bauldry, S.	2014.	miivfind: A command for identifying model-implied instrumental
	variables for structural equation models in Stata.	\emph{Stata Journal}, 14:4.
}

