% Generated by roxygen2 (4.0.1): do not edit by hand
\name{MIICD.crreg}
\alias{MIICD.crreg}
\title{Fine & Gray regression for interval censored competing risks data using multiple imputation}
\usage{
MIICD.crreg(formula, k, m, status, trans, cens.code, data, method = c("PMDA",
  "ANDA"), verbose = FALSE)
}
\arguments{
\item{formula}{A formula. The right hand side indicates names of covariables to be found in \code{data}}

\item{verbose}{Logical, display the results ?}

\item{method}{Which data augmentation scheme shall be used ? Two algorithms are implemented : \emph{The Poor man's Data Augmentation
scheme} and the \emph{Asymptotic Normal Data Augmentation scheme} (the later may be preferred).}

\item{k}{An integer, indicates the number of iteration to perform}

\item{m}{An integer, indicates the number of imputation to perform at each iteration}

\item{status}{The name of the column where status are to be found}

\item{trans}{Denomination of the event of interest in the status column}

\item{cens.code}{Censor indicator in the status column of the data}

\item{data}{The input data (see details)}
}
\value{
\code{Coef.} Final estimate of the coefficient

\code{vcov}  Final estimate of the variance-covariance matrix

\code{Coef_seq} Sequence of the coefficient estimate over iterations

\code{Sigma_seq} Sequence of the coefficient standard deviation over iterations

\code{df} data frame containing the main results

\code{\dots} Other returned values
}
\description{
Uses the multiple imputation approach to compute regression coefficient and its associated
 variance-covariance matrix, and baseline cumulative incidence estimates for interval censorded competing risks data
}
\details{


This function uses data augmentation and multiple imputation aproach to estimate regression coefficient, variance-covariance
 matrix and baseline cumulative incidence estimates in a competing risks proportional hazards regression model for interval censorded
 competing risks data.

 Estimates are computed using Rubin's rules (Rubin (1987)). Estimate of coefficient is computed as the mean of estimates over
  imputation. The variance-covariance matrix is computed as the within imputation variance and the between imputation variance
  augmented byan inflation factor to take into account the finite number of imputation. At each iteration, the baseline cumulative
  incidence function is updated  and multiple imputation is performed using the updated estimates. Print and plot methods are
  available to handle results.

 \code{Print} and \code{plot} methods are available to handle results.

 The \code{data} must contain at last four columns. One named \code{left}, one named \code{right}, the name of the 3^{rd} is indicated
 by the \code{status} parameter and one for the covariate to be tested.  For interval censored data, the left and right columns
 indicates the lower and the upper bounds of the intervals respectively. \code{Inf} in the right column stands for right censored
 observations. When an observation is right censored, the \code{status} column must contain the censor indicator specified by
 \code{cens.code}. The transition of interest must be precised by the \code{trans} parameter.
}
\examples{
res <- MIICD.crreg(formula = ~ treatment, k = 5, m = 5, status = 'status',
 trans = 1, data = ICCRD,  cens.code = 0, method = 'ANDA', verbose = FALSE )
 res
 plot(res)
 #diagnostic plot for coefficients end associated standard error
 plot(res , type = 'coef' , coef = 1)
 plot(res , type = 'sigma' , coef = 1)
}
\author{
Marc Delord \email{<mdelord@gmail.com>}
}
\references{
Delord, M. & Genin, E. Multiple Imputation for Competing Risks Regression with Interval Censored Data Journal of Statistical
 Computation and Simulation, 2015

Fine JP and Gray RJ (1999) A proportional hazards model for the subdistribution of a competing risk. JASA 94:496-509.

PAN, Wei. A Multiple Imputation Approach to Cox Regression with Interval-Censored Data. Biometrics, 2000, vol. 56, no 1,
  p. 199-203.

Rubin, D. B. (1987). Multiple imputation for nonresponse in surveys.

Schenker, N. and Welsh, A. (1988). Asymptotic results for multiple imputation. The Annals of Statistics pages 1550-1566.

Tanner, M. A. and Wong, W. H. (1987). An application of imputation to an estimation problem in grouped lifetime analysis.
 Technometrics 29, 23-32.

Wei, G. C., & Tanner, M. A. (1991). Applications of multiple imputation to the analysis of censored regression data.
 Biometrics, 47(4), 1297-1309.
}
\seealso{
\link[survival]{Surv}, \link[survival]{survfit}, \link[riskRegression]{FGR}, \link[MASS]{mvrnorm}
}

