\name{labelswitch}
\alias{labelswitch}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Label switching correction.
}
\description{
This function corrects for the issue of label switching when fitting mixture models in a Bayesian setting.
}
\usage{
labelswitch(mu, sigma2, lambda, tau, K, G, d, perms, muMAP, iter, 
uphill, burnin, thin, s, x.mix)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mu}{
A G x d matrix of mean latent locations.
}
  \item{sigma2}{
A vector of length G containing the covariance of the latent locations within each cluster.
}
  \item{lambda}{
An n x G matrix of mixing proportions.
}
  \item{tau}{
A matrix of logistic regression coefficients, with G rows and number of columns equal to the number of covariates in the mixing proportions model plus 1, for the intercept.
}
  \item{K}{
Vector of length n detailing the number of the cluster to which each node belongs.
}
  \item{G}{
The number of clusters in the model being fitted.
}
  \item{d}{
The dimension of the latent space.
}
  \item{perms}{
A G! x G matrix of all possible permutations of 1:G (output by permutations(G), say).
}
  \item{muMAP}{
A G x d matrix of \emph{maximum a posteriori} latent location means, obtained at the end of the uphill only section of the MCMC chain. Used as the template to correct for label switching.
}
  \item{iter}{
Iteration number.
}
  \item{uphill}{
Number of iterations for which uphill only steps in the MCMC chain should be run.
}
  \item{burnin}{
Number of iterations of the MCMC chain which should not be included in \emph{a posteriori} summaries.
}
  \item{thin}{
Thinning frequency of the MCMC chain to ensure independent samples.
}
  \item{s}{
Number of columns in the reformatted covariates matrix for the mixing proportions model, output by \code{\link{formatting.covars}}.
}
  \item{x.mix}{
The reformatted covariates matrix for the mixing proportions model, output by \code{\link{formatting.covars}.}
}
}
\details{
The muMAP matrix is used as the reference to which each new estimate the cluster means is matched to correct for any label switching which may have occurred during sampling. A sum of squares function is employed as the loss function.
}
\value{
A list containing:list(mu, sigma2, lambda, tau, K)
\item{mu}{The label-corrected matrix of cluster means.}
\item{sigma2}{The label-corrected vector of cluster covariances.}
\item{lambda}{The label-corrected matrix of mixing proportions.}
\item{tau}{The label-corrected matrix of logistic regression coefficients for the mixing proportions model.}
\item{K}{The label-corrected vector of length n detailing the number of the cluster to which each node belongs.}

}
\references{
Isobel Claire Gormley and Thomas Brendan Murphy. (2010) A Mixture of Experts Latent Position Cluster Model for Social Network Data. Statistical Methodology, 7 (3), pp.385-405.
}
\author{
Isobel Claire Gormley <claire.gormley@ucd.ie>
}

\seealso{
\code{\link{MEclustnet}}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{internal}
