% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{seqdef}
\alias{seqdef}
\title{Create a state sequence object}
\usage{
seqdef(data, ...)
}
\arguments{
\item{data}{A data frame or matrix containing sequence data.}

\item{...}{All other arguments; see \code{\link[TraMineR]{seqdef}} in the \pkg{TraMineR} package.}
}
\value{
An object of class \code{"stslist"}, for which dedicated \code{print} and \code{summary} methods are inherited from \pkg{TraMineR}.
}
\description{
Create a state sequence object with attributes such as alphabet, colour palette, and state labels. This a minimalist copy of \code{\link[TraMineR]{seqdef}} in the \pkg{TraMineR} package.
}
\details{
This function exists only so experienced users of \pkg{MEDseq} and \pkg{TraMineR} can use the former without explicitly requiring the latter to be loaded. In particular, \code{\link{MEDseq_fit}} requires a state-sequence object of class \code{"stslist"} (as created by \code{seqdef}) as input. Users are encouraged to see the documentation at \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} for complete details and further examples.
}
\examples{
data(mvad)
# Create a state sequence object with the first two (summer) time points removed
states   <- c("EM", "FE", "HE", "JL", "SC", "TR")
labels   <- c("Employment", "Further Education", "Higher Education", 
              "Joblessness", "School", "Training")
mvad.seq <- seqdef(mvad[,17:86], states=states, labels=labels, weights=mvad$weight)
}
\references{
Gabadinho, A., Ritschard, G., Mueller, N. S., and Studer, M. (2011). Analyzing and visualizing state sequences in R with \pkg{TraMineR}. \emph{Journal of Statistical Software}, 40(4): 1-37.

Gabadinho, A., Ritschard, G., Studer, M., and Mueller, N. S. (2010). Mining sequence data in \code{R} with the \pkg{TraMineR} package: a user's guide. \emph{Department of Econometrics and Laboratory of Demography, University of Geneva}.
}
\seealso{
\code{\link[TraMineR:seqdef]{TraMineR::seqdef}}, \code{\link{MEDseq_fit}}
}
\author{
Alexis Gabadinho and Gilbert Ritschard
}
\keyword{utility}
