% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_variable.R
\docType{class}
\name{functional_variable-class}
\alias{functional_variable-class}
\alias{functional_variable}
\title{Function-valued variable data.}
\description{
A s4 class that represents data of a function-valued variable.
The format is
  \eqn{f_i(t),\ t\in\Omega=[t_0,t_0 + T]}
  where $i$ is the observation (subject) index, $t$ represents the measurement (time) points.
}
\section{Slots}{

\describe{
\item{\code{X}}{a matrix \eqn{(x_{ij})_{n\times m}}, where \eqn{x_{ij} = f_i(t_j)}, represents the value of \eqn{f_i(t_j)}, each row represent an observation (subject), each column is corresponding to a measurement (time) point.}

\item{\code{t_0}}{start of the domain (time period), \eqn{t_0}. Default is 0.}

\item{\code{period}}{length of the domain (time period), \eqn{T}. Default is 1.}

\item{\code{t_points}}{sequence of the measurement points, \eqn{(t_1,\dots,t_m)}. Default is \eqn{t_k = t_0 + \frac{(2k-1)T}{2(m+1)}}.}
}}

\examples{
X = array(rnorm(12),dim = 4:3)
functional_variable(X=X,period = 3)
}
\author{
Heyang Ji
}
