\name{extract.mdd.mantelhaen}
\alias{extract.mdd.mantelhaen}
\title{Extract MDD from Previously Generated Data}
\description{
Takes a response array generated by \code{\link{mdd.mantelhaen.pow}}
and extracts the minimum detectable difference for the given number of 
observed control responses.
}
\usage{
extract.mdd.mantelhaen(placebo.vals, from.file = NULL, print.summary = TRUE, sig.inds)
}
\arguments{
  \item{placebo.vals}{number of observed responses in each control stratum.}
  \item{from.file}{path for file containing response array created by 
\code{\link{mdd.mantelhaen.pow}}.}
  \item{print.summary}{a logical indicating whether to print a summary of the results in paragraph form.}
  \item{sig.inds}{only used if \code{from.file} is not defined; otherwise, this takes its value from 
the object loaded by \code{from.file}.}
}
\value{
 A list with the following components:
  \item{le}{A matrix with rows consisting of all non-comparable (see below) treatment response 
  scenarios for which the test statistic will be significant by virtue of the treatment response 
  rate being less than the control response rate.}
  \item{ge}{A matrix with rows consisting of all non-comparable (see below) treatment response 
  scenarios for which the test statistic will be significant by virtue of the treatment response 
  rate being greater than the control response rate.}
  If \code{print.summary = TRUE}, this is returned invisibly.
}
\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}
\note{
\dQuote{Non-comparable} refers to the fact that if, for example, \code{c(2,3)} is in the \code{le}
component, then \code{c(2,2)}, \code{c(1,3)}, \code{c(1,2)}, etc., would all be significant as well.
On the other hand, \code{c(3,2)} and \code{c(0,4)} might or might not be.  In particular, for any 
two rows in the \code{le} component, there will be at least one column which is strictly greater 
in the first row than the second, and at least one column which is strictly greater 
in the second row than the first; and similarly for the \code{gr} component.

The function is meant to be used with \code{from.file} rather than \code{sig.inds}, but the 
other option is provided for convenience.}
\section{Warning}{
See the Warning section of \code{\link{mdd.mantelhaen.pow}} for a note about slight inaccuracies 
in the algorithm used there.
}

\seealso{\code{\link{mdd.mantelhaen.pow}} for the form that \code{sig.inds} needs to be in, 
\code{\link{mdd.mantelhaen}} for a faster version}
\examples{
tmp.file <- paste(tempfile(),".RData",sep="")
mh.pow <- mdd.mantelhaen.pow(c(8,9), c(10,7), .25, to.file=tmp.file)
mh.pow1 <- extract.mdd.mantelhaen(c(5,4), from.file=tmp.file, print.summary=FALSE)
mh.pow2 <- mdd.mantelhaen(c(8,9), c(10,7), c(5,4), print.summary=FALSE)
all.equal(mh.pow1, mh.pow2)

#Note: they are not identical, because the entries of mh.pow2$gr are of class  
#"integer", while the entries of mh.pow1$gr are of class "numeric".  This 
#"feature" will be eliminated in a future version of the package (once I figure
#out why it's happening). 

file.remove(tmp.file)
rm(tmp.file,mh.pow,mh.pow1,mh.pow2)

}
\keyword{htest}
