% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pBED.R
\name{pBED}
\alias{pBED}
\title{Joint CDF of the bivariate exponential distribution (BED) based on the Moran-Downton model}
\usage{
pBED(rho,Betax,Betay,x,y)
}
\arguments{
\item{rho}{Correlation coefficient between the marginal distributions of x and y.}

\item{Betax}{Scale parameter of the marginal distribution of x.}

\item{Betay}{Scale parameter of the marginal distribution of y.}

\item{x}{A value or set of values (vector) of the marginal distribution of x. It must be the same size of y.}

\item{y}{A value or set of values (vector) of the marginal distribution of y. It must be the same size of x.}
}
\value{
The value of the joint CDF of the pair/s (x,y).
}
\description{
Given the values of the parameters, this function provides the value of the joint CDF of the BED for a positive pair or pairs
(x,y). The required inputs are the correlation coefficient, the scale parameters of the marginal distributions, and the pair/s (x,y).
}
\details{
The values of the joint density function are computed based on Eq.10.54 described in \insertCite{Balakrishna2009;textual}{MDBED}.
}
\examples{
pBED(rho=0.85,Betax=1,Betay=1, x=0.6,y=0.8)
}
\references{
\insertAllCited{}
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
