% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_pvals.R
\name{power_pvals}
\alias{power_pvals}
\title{This function finds the power for tests that find their own p values}
\usage{
power_pvals(
  rxy,
  avals,
  bvals,
  TS,
  typeTS,
  TSextra = list(a = 0),
  nbins = c(5, 5),
  minexpcount = 5,
  Ranges = matrix(c(-Inf, Inf, -Inf, Inf), 2, 2),
  alpha = 0.05,
  B = 1000
)
}
\arguments{
\item{rxy}{a function to generate data}

\item{avals}{vector of parameter values}

\item{bvals}{vector of parameter values}

\item{TS}{routine that runs the test and returns p values}

\item{typeTS}{type of problem, continuous or discrete}

\item{TSextra}{=list(a=0) a list of things passed to TS, if needed}

\item{nbins}{=c(5, 5), bins for chi square tests.}

\item{minexpcount}{=5, lowest required count for chi-square test}

\item{Ranges}{=matrix(c(-Inf, Inf, -Inf, Inf),2,2) a 2x2 matrix with lower and upper bounds}

\item{alpha}{=0.05 type I error probability of test}

\item{B}{=1000 number of simulation runs}
}
\value{
A matrix of power values
}
\description{
This function finds the power for tests that find their own p values
}
\keyword{internal}
