% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{tuser}
\alias{tuser}
\title{User-defined time-course function}
\usage{
tuser(
  fun,
  pool.1 = "rel",
  method.1 = "common",
  pool.2 = "rel",
  method.2 = "common",
  pool.3 = "rel",
  method.3 = "common",
  pool.4 = "rel",
  method.4 = "common"
)
}
\arguments{
\item{fun}{A formula specifying any relationship including \code{time} and
one/several of: \code{beta.1}, \code{beta.2}, \code{beta.3}, \code{beta.4}.}

\item{pool.1}{Pooling for \code{beta.1}. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.1}{Method for synthesis of \code{beta.1}. Can take \verb{"common} or \code{"random"} (see details).}

\item{pool.2}{Pooling for \code{beta.2}. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.2}{Method for synthesis of \verb{beta.2. Can take }"common\code{or}"random"` (see details).}

\item{pool.3}{Pooling for \verb{beta.3. Can take }"rel"\code{or}"abs"` (see details).}

\item{method.3}{Method for synthesis of \verb{beta.3. Can take }"common\code{or}"random"` (see details).}

\item{pool.4}{Pooling for \verb{beta.4. Can take }"rel"\code{or}"abs"` (see details).}

\item{method.4}{Method for synthesis of \code{beta.4}. Can take \verb{"common} or \code{"random"} (see details).}
}
\value{
An object of \code{class("timefun")}
}
\description{
User-defined time-course function
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
}


When relative effects are modelled on more than one time-course parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
This prior can be made slightly more informative by specifying the scale matrix \code{omega}
and by changing the degrees of freedom of the inverse-Wishart prior
using the \code{priors} argument in \code{mb.run()}.
}

\examples{

timecourse <- ~ beta.1 * (1/(time+1)) + beta.2 * time^2
tuser(fun=timecourse,
  pool.1="abs", method.1="common",
  pool.2="rel", method.2="common")

}
\references{
\insertAllCited
}
