% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{tfpoly}
\alias{tfpoly}
\title{Fractional polynomial time-course function}
\usage{
tfpoly(
  degree = 1,
  pool.1 = "rel",
  method.1 = "common",
  pool.2 = "rel",
  method.2 = "common",
  method.power1 = "common",
  method.power2 = "common"
)
}
\arguments{
\item{degree}{The degree of the fractional polynomial as defined in  \insertCite{royston1994;textual}{MBNMAtime}}

\item{pool.1}{Pooling for the 1st fractional polynomial coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.1}{Method for synthesis of the 1st fractional polynomial coefficient. Can take \verb{"common} or \code{"random"} (see details).}

\item{pool.2}{Pooling for the 2nd fractional polynomial coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.2}{Method for synthesis of the 2nd fractional polynomial coefficient. Can take \verb{"common} or \code{"random"} (see details).}

\item{method.power1}{Method for synthesis of the 1st fractional polynomial power. Can take \verb{"common} or \code{"random"} (see details).
\code{pool} for this parameter is set to \code{"abs"}.}

\item{method.power2}{Method for synthesis of the 2nd fractional polynomial power. Can take \verb{"common} or \code{"random"} (see details).
\code{pool} for this parameter is set to \code{"abs"}.}
}
\value{
An object of \code{class("timefun")}
}
\description{
As first described for use in Network Meta-Analysis by \insertCite{jansen2015;textual}{MBNMAtime}.
}
\details{
\itemize{
\item \eqn{\beta_1} represents the 1st coefficient.
\item \eqn{\beta_2} represents the 2nd coefficient.
\item \eqn{p_1} represents the 1st power
\item \eqn{p_2} represents the 2nd power
}

For a polynomial of \code{degree=1}:
\deqn{{\beta_1}x^{p_1}}

For a polynomial of \code{degree=2}:
\deqn{{\beta_1}x^{p_1}+{\beta_2}x^{p_2}}

\eqn{x^{(p)}} is a regular power except where \eqn{p=0}, where \eqn{x^{(0)}=ln(x)}.
If a fractional polynomial power \eqn{p_m} repeats within the function it is multiplied by another \eqn{ln(x)}.
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
}


When relative effects are modelled on more than one time-course parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
This prior can be made slightly more informative by specifying the scale matrix \code{omega}
and by changing the degrees of freedom of the inverse-Wishart prior
using the \code{priors} argument in \code{mb.run()}.
}

\examples{
# 1st order fractional polynomial with random effects
tfpoly(pool.1="rel", method.1="random")

# 2nd order fractional polynomial
# with a single absolute parameter estimated for the 2nd coefficient
# 1st power estimated as exchangeable (random) across studies
tfpoly(degree=2, pool.1="rel", method.1="common",
  pool.2="abs", method.2="random",
  method.power1="random")

}
\references{
\insertAllCited
}
