% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.functions.R
\name{rankauc}
\alias{rankauc}
\title{Calculates ranking probabilities for AUC from a time-course MBNMA}
\usage{
rankauc(
  mbnma,
  lower_better = FALSE,
  treats = NULL,
  level = "treatments",
  int.range = c(0, max(mbnma$network$data.ab$time)),
  n.iter = mbnma$BUGSoutput$n.sims,
  subdivisions = 100,
  ...
)
}
\arguments{
\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a time-course MBNMA model}

\item{lower_better}{Indicates whether negative responses are better (\code{lower_better=TRUE}) or
positive responses are better (\code{lower_better=FALSE})}

\item{treats}{A character vector of treatment/class names (depending on the value of \code{level}). If left \verb{NULL`` then rankings will be calculated for all treatments/classes. Note that unlike }rank.mbnma()` this argument
cannot take a numeric vector.}

\item{level}{Can take either \code{"treatment"} to make predictions for treatments, or \code{"class"} to make predictions for classes (in
which case \code{object} must be a class effect model).}

\item{int.range}{A numeric vector with two elements that indicates the range
over which to calculate AUC. Takes the form c(lower bound, upper bound). If left
as \code{NULL} (the default) then the range will be between zero and the maximum follow-up
time in the dataset.}

\item{n.iter}{The number of iterations for which to calculate AUC (if \code{"auc"} is included in \code{params}).
Must be a positive integer. Default is the value used in \code{mbnma}.}

\item{subdivisions}{The number of subdivisions over which to integrate (see \code{\link[stats]{integrate}})}

\item{...}{Arguments to be sent to R2jags for synthesis of the network
reference treatment effect (using \code{\link[=ref.synth]{ref.synth()}})}
}
\value{
A named list whose elements correspond to parameters given in
\code{params}. Each element contains:
\itemize{
\item \code{summary.rank} A data frame containing
mean, sd, and quantiles for the ranks of each treatment given in \code{treats}
\item \code{prob.matrix} A matrix of the proportions of MCMC results for which each
treatment in \code{treats} ranked in which position for the given parameter
\item \code{rank.matrix} A matrix of the ranks of MCMC results for each treatment in
\code{treats} for the given parameter.
}
}
\description{
Calculates ranking probabilities for AUC from a time-course MBNMA
}
\details{
\code{"auc"} can be included in \code{params} to rank treatments based on
Area Under the Curve (AUC). This accounts for the effect of multiple
time-course parameters simultaneously on the treatment response, but will
be impacted by the range of time over which AUC is calculated (\code{int.range}).
This requires integration over \code{int.range} and can take some time to run (particularly)
for spline functions as this uses the trapezoid method rather than adaptive quadrature).

As with other post-estimation functions, \code{rank()} should only be performed on
models which have successfully converged. Note that rankings can be very sensitive to
even small changes in treatment effects and therefore failure to converge in only
one parameter may have substantial impact on rankings.
}
