% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbnma-class.R
\name{plot.mbnma}
\alias{plot.mbnma}
\title{Forest plot for results from time-course MBNMA models}
\usage{
\method{plot}{mbnma}(x, params = NULL, treat.labs = NULL, class.labs = NULL, ...)
}
\arguments{
\item{x}{An S3 object of class \code{"mbnma"} generated by running
a time-course MBNMA model}

\item{params}{A character vector of time-course parameters to plot.
Parameters must be given the same name as monitored nodes in \code{mbnma} and must vary by treatment or class. Can be set to
\code{NULL} to include all available time-course parameters estimated by \code{mbnma}.}

\item{treat.labs}{A character vector of treatment labels. If left as \code{NULL} (the default) then
labels will be used as defined in the data.}

\item{class.labs}{A character vector of class labels if \code{mbnma} was modelled using class effects
If left as \code{NULL} (the default) then labels will be used as defined in the data.}

\item{...}{Arguments to be sent to \code{ggdist::stat_halfeye()}}
}
\value{
A forest plot of class \code{c("gg", "ggplot")} that has separate panels for different time-course parameters
}
\description{
Generates a forest plot for time-course parameters of interest from results from time-course MBNMA models.
Posterior densities are plotted above each result using \code{ggdist:stat_:halfeye()}
}
\examples{
\donttest{
# Create an mb.network object from a dataset
alognet <- mb.network(alog_pcfb)

# Run an MBNMA model with an Emax time-course
emax <- mb.run(alognet,
  fun=temax(pool.emax="rel", method.emax="common",
    pool.et50="rel", method.et50="common"),
  intercept=FALSE)

# Generate forest plot
plot(emax)

# Plot results for only one time-course parameter
plot(emax, params="emax")
}
}
