% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.functions.R
\name{ref.synth}
\alias{ref.synth}
\title{Synthesise single arm studies with repeated observations of the same
treatment over time}
\usage{
ref.synth(data.ab, mbnma, synth = "random",
  n.iter = mbnma$BUGSoutput$n.iter,
  n.burnin = mbnma$BUGSoutput$n.burnin,
  n.thin = mbnma$BUGSoutput$n.thin,
  n.chains = mbnma$BUGSoutput$n.chains, ...)
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the
columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{y} Numeric data indicating the mean response for a given observation
\item \code{se} Numeric data indicating the standard error for a given observation
}}

\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a time-course MBNMA model}

\item{synth}{A character object that can take the value \code{"fixed"} or \code{"random"} that
specifies the the type of pooling to use for synthesis of \code{ref.resp}. Using \code{"random"} rather
than \code{"fixed"} for \code{synth} will result in wider 95\% CrI for predictions.}

\item{n.iter}{number of total iterations per chain (including burn in;
    default: 2000)}

\item{n.burnin}{length of burn in, i.e. number of iterations to
    discard at the beginning. Default is \code{n.iter/2}, that is,
    discarding the first half of the simulations. If n.burnin is 0,
    \code{jags()} will run 100 iterations for adaption.}

\item{n.thin}{thinning rate. Must be a positive integer.  Set
    \code{n.thin} > 1 to save memory and computation time if
    \code{n.iter} is large.  Default is \code{max(1, floor(n.chains *
    (n.iter-n.burnin) / 1000))} which will only thin if there are at
    least 2000 simulations.}

\item{n.chains}{number of Markov chains (default: 3)}

\item{...}{Arguments to be sent to R2jags for synthesis of the network
reference treatment effect (using \code{\link[=ref.synth]{ref.synth()}})}
}
\value{
A list of named elements corresponding to each time-course parameter
within an MBNMA model that contain the median posterior value for the
network reference treatment response.
}
\description{
Synthesises single arm studies with repeated measures by applying a
particular time-course function. Used in predicting mean responses from a
time-course MBNMA. The same parameterisation of the time course must be used
as in the MBNMA.
}
\details{
\code{data.ab} can be a collection of studies that closely resemble the
population of interest intended for the prediction, which could be
different to those used to estimate the MBNMA model, and could be include
single arms of RCTs or observational studies. If other data is not
available, the data used to estimate the MBNMA model can be used by
selecting only the studies and arms that specify the network reference
treatment responses.
}
\examples{
\donttest{
# Create an mb.network object from a dataset
network <- mb.network(osteopain)

# Run an MBNMA model with an Emax time-course
emax <- mb.emax(network,
  emax=list(pool="rel", method="common"),
  et50=list(pool="rel", method="random"),
  positive.scale=TRUE)

# Generate a set of studies with which to estimate the network reference treatment response
paindata.ref <- osteopain[osteopain$treatname=="Placebo_0",]

# Estimate the network reference treatment effect using fixed effects meta-analysis
ref.synth(data.ab=paindata.ref, mbnma=emax, synth="fixed")

# Estimate the network reference treatment effect using random effects meta-analysis
ref.synth(data.ab=paindata.ref, mbnma=emax, synth="random")
}

}
