% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_cox.R
\name{bc}
\alias{bc}
\title{Box-Cox transform}
\usage{
bc(y, lambda, eps = 1e-04)
}
\arguments{
\item{y}{numeric, the original observations}

\item{lambda}{numeric, the box-cox power}

\item{eps}{numeric, a guard aroung lambda = 0}
}
\value{
A vector of transformed quantities
}
\description{
Compute the box-cox transform of a vector of values, handling
the region near lambda = 0 with some care
}
\examples{
plot(12:50, bc(12:50, -1), type = "l", xlab = "MPG", ylab = "bc(MPG, -1)",
     las = 1, col = "sky blue", panel.first = grid())
points(bc(MPG.city, -1) ~ MPG.city, data = Cars93, pch = 16, cex = 0.7)
}
