% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_06_DE_1_1_CompareValues_PSI.R
\name{CompareValues.PSI}
\alias{CompareValues.PSI}
\title{Differential Splicing Analysis}
\usage{
CompareValues.PSI(
  MarvelObject,
  cell.type.columns.1,
  cell.type.variables.1,
  cell.type.columns.2,
  cell.type.variables.2,
  n.cells,
  method,
  method.adjust,
  event.type
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{ComputePSI} function.}

\item{cell.type.columns.1}{Character string. To indicate which columns in the \code{MarvelObject$SplicePheno} slot to refer to when filtering samples (cells) for analysis. This is for the first group of cells (reference group).}

\item{cell.type.variables.1}{List of character string. To indicate which specific variables of the corresponding columns to keep the samples (cells). This should be same length as the \code{cell.type.columns.1} argument. This is for the first group of cells (reference group).}

\item{cell.type.columns.2}{Character string. To indicate which columns in the \code{MarvelObject$SplicePheno} slot to refer to when filtering samples (cells) for analysis. This is for the 2nd group of cells (non-reference group).}

\item{cell.type.variables.2}{List of character string. To indicate which specific variables of the corresponding columns to keep the samples (cells). This should be same length as the \code{cell.type.columns.2} argument. This is for the 2nd group of cells  (non-reference group).}

\item{n.cells}{Numeric value. The minimum no. of cells expressing the splicing event for the event to be included for differential splicing analysis.}

\item{method}{Character string. Statistical test to compare the 2 groups of cells. \code{"ks"}, \code{"kuiper"}, \code{"ad"}, \code{"wilcox"}, and \code{"t.test"} for Kolmogorov-Smirnov, Kuiper, Anderson-Darling, Wilcox, and t-test, respectively.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}

\item{event.type}{Character string. Indicate which splicing event type to include for analysis. Can take value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"}, or \code{"A3SS"} which represents skipped-exon (SE), mutually-exclusive exons (MXE), retained-intron (RI), alternative 5' splice site (A5SS), and alternative 3' splice site (A3SS), respectively.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$DE$PSI}.
}
\description{
\code{CompareValues.PSI} performs differentially splicing analysis between 2 groups of cells.
}
\details{
This function compares the percent spliced-in (PSI) values between 2 groups of cells.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- CompareValues.PSI(MarvelObject=marvel,
                            cell.type.columns.1=c("cell.type"),
                            cell.type.variables.1=list("iPSC"),
                            cell.type.columns.2=c("cell.type"),
                            cell.type.variables.2=list("Endoderm"),
                            n.cells=2,
                            method="t.test",
                            method.adjust="fdr",
                            event.type=c("SE", "MXE", "RI", "A5SS", "A3SS")
                            )

# Check output
marvel$DE$PSI$Table[1:5, ]
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
