% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_02_2_2_PropModality_Bar.R
\name{PropModality.Bar}
\alias{PropModality.Bar}
\title{Modality Proportion across Event Types.}
\usage{
PropModality.Bar(MarvelObject, modality.column, modality.type, event.type,
  prop.test, prop.adj)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{AssignModality} function.}

\item{modality.column}{Character string. Can take the value \code{"modality"}, \code{"modality.var"} or \code{"modality.bimodal.adj"}. Please refer to \code{AssignModality} function help page for more details.}

\item{modality.type}{Character string. \code{basic} indicates that only the main modalities (included, excluded, bimodal, middle, multimodal) are analysed. Sub-modalities (primary and dispersed) will be merged. \code{extended} indicates that both main and sub-modalities are analysed. Sub-modalities will not be merged.}

\item{event.type}{Character string. To indicate which event type to analyse. Can take the value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"} or \code{"A3SS"}. Specify \code{"all"} to include all event types.}

\item{prop.test}{Character string. Only applicable when \code{across.event.type} set to \code{TRUE}. \code{chisq} Chi-squared test used to compare the proportion of modalities across the different event splicing type. \code{fisher} Fisher test used to compare the proportion of modalities across the different splicing event type.}

\item{prop.adj}{Character string. Only applicable when \code{across.event.type} set to \code{TRUE}. Adjust p-values generated from \code{prop.test} for multiple testing. Options available as per \code{p.adjust} function.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{$Modality$Prop$BarChart} slot.
}
\description{
\code{PropModality.Bar} compares proportion of each modality across specified splicing event types.
}
\details{
This function compares proportion of each modality across specified splicing event types.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

marvel <- PropModality.Bar(MarvelObject=marvel,
                           modality.column="modality.bimodal.adj",
                           modality.type="basic",
                           event.type="all",
                           prop.test="fisher",
                           prop.adj="fdr"
                          )

marvel$Modality$Prop$BarChart$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
