% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterMAF.R
\name{filterMAF}
\alias{filterMAF}
\title{Function to filter the mutations}
\usage{
filterMAF(
  mafFilePath,
  flag_genes = "default",
  save_name = NULL,
  no_filter = FALSE,
  norm_alt_max = 1,
  t_alt_min = 1,
  t_depth_min = 20,
  tumor_freq_min = 0.05,
  norm_freq_max = 0.02,
  gnomAD_AF_max = 0.001,
  AF_max = 0.001,
  ExAC_AF_max = 0.001,
  n_callers = 2,
  variant_caller = NULL
)
}
\arguments{
\item{mafFilePath}{The path of the file containing the mutation
information in the MAF format}

\item{flag_genes}{The list of genes used as flag genes}

\item{save_name}{The name and path of the output file to save filtered MAFs}

\item{no_filter}{Flag to filter the MAF (Default no_filter=FALSE)}

\item{norm_alt_max}{Alt norm max (Default norm_alt_max=1)}

\item{t_alt_min}{Alt t min (Default t_alt_min=1)}

\item{t_depth_min}{Depth t min (Default t_depth_min=20)}

\item{tumor_freq_min}{Tumor Frequency Minimum (Default tumor_freq_min=0.05)}

\item{norm_freq_max}{norm_freq_max (Default norm_freq_max=0.02)}

\item{gnomAD_AF_max}{Maximum allele frequency in gnomAD database  (Default gnomAD_AF_max=0.001)}

\item{AF_max}{Maximum allele frequency in 1000 genome database (Default AF_max=0.001)}

\item{ExAC_AF_max}{Maximum allele frequency in ExAC database (Default ExAC_AF_max=0.01)}

\item{n_callers}{Minimum number of callers identified mutation. (Default n_callers=2)}

\item{variant_caller}{Name of variant caller to be used or "consensus"
to apply filter based on `n_callers` (Default variant_caller=NULL)}
}
\value{
An object of class MAF with the filtered mutations
}
\description{
This function filter the mutations in the MAF format using thresholds on various features
}
\examples{
library(MAFDash)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
filteredMAF <- filterMAF(mafFilePath = maf)

}
\author{
Mayank Tandon, Ashish Jain
}
