% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clusters.R
\name{get_clusters}
\alias{get_clusters}
\title{Predict Complexes}
\usage{
get_clusters(
  csize = 2,
  d = 0.3,
  p = 2,
  max_overlap = 0.8,
  tpath = file.path(system.file("extdata", package = "MACP"))
)
}
\arguments{
\item{csize}{An integer, the minimum size of the predicted complexes.
Defaults to 2.}

\item{d}{A number, density of predicted complexes. Defaults to 0.3.}

\item{p}{An integer, penalty value for the inclusion of each node.
Defaults to 2.}

\item{max_overlap}{A number, specifies the maximum allowed
overlap between two clusters. Defaults to 0.8.}

\item{tpath}{A character string indicating the path to the project
directory that contains the interaction data. Interactions data must be
stored as .txt file and containing id1-id2-weight triplets.}
}
\value{
A data.frame containing predicted complexes
}
\description{
This function partitions high-confidence network to
putative complexes via ClusterONE clustering algorithm to identify
protein complex membership.
}
\details{
get_clusters
}
\examples{
predcpx <-
get_clusters(csize = 3, d = 0.3, p = 2,
max_overlap = 0.8,
tpath = file.path(system.file("extdata", package = "MACP")))
}
\references{
Nepusz, T., Yu, H., and Paccanaro, A. (2012a).
Detecting overlapping protein complexes in protein-protein interaction
networks. Nat. Methods 9, 471.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
