% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_DenoisedNet.R
\name{get_DenoisedNet}
\alias{get_DenoisedNet}
\title{Denoising Predicted Protein-Protein Interactions}
\usage{
get_DenoisedNet(ppi)
}
\arguments{
\item{ppi}{Interactions data containing id1-id2-weight triplets.}
}
\value{
A data.frame containing denoised network.
}
\description{
This function removes the noise in the form of false
positive edges in the predicted networks using network topology.
}
\details{
get_DenoisedNet
}
\examples{
# high-confidence network as input
ppi <-
read.table(system.file("extdata/ppi_input_ClusterONE.txt",
package="MACP"),
quote="\"", comment.char="")
# Perform network denoising
denoisetNet <- get_DenoisedNet(ppi)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
