/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import com.sosnoski.util.array.IntArray;
import java.util.List;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.view.model.CyNetworkView;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ui.NodeSetPropertiesPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNetworkUtil;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.Graph;

public class SelectionPropertiesPanel
extends NodeSetPropertiesPanel
implements SetCurrentNetworkViewListener,
RowsSetListener {
    private ClusterONECytoscapeApp app;
    private ControlPanel panel;
    CyNetworkView watchedNetworkView = null;

    public SelectionPropertiesPanel(ControlPanel panel) {
        this.app = panel.app;
        this.panel = panel;
        if (panel != null) {
            this.setQualityFunction(panel.getParameters().getQualityFunction());
        }
        this.setWatchedNetworkView(this.app.getCurrentNetworkView());
        this.app.registerService(this, SetCurrentNetworkViewListener.class);
        this.app.registerService(this, RowsSetListener.class);
        this.updateNodeSetFromSelection();
    }

    public void handleEvent(SetCurrentNetworkViewEvent event) {
        this.setWatchedNetworkView(event.getNetworkView());
        this.updateNodeSetFromSelection();
    }

    public void handleEvent(RowsSetEvent event) {
        if (this.watchedNetworkView == null) {
            return;
        }
        CyNetwork network = (CyNetwork)this.watchedNetworkView.getModel();
        if (network == null) {
            return;
        }
        if (event.getSource() != network.getDefaultNodeTable()) {
            return;
        }
        if (!event.containsColumn("selected")) {
            return;
        }
        this.updateNodeSetFromSelection();
    }

    private void setWatchedNetworkView(CyNetworkView networkView) {
        if (this.watchedNetworkView == networkView) {
            return;
        }
        this.watchedNetworkView = networkView;
    }

    public void updateNodeSetFromSelection() {
        if (this.watchedNetworkView == null) {
            return;
        }
        CyNetwork network = (CyNetwork)this.watchedNetworkView.getModel();
        if (network == null) {
            return;
        }
        List<CyNode> selectedNodes = CyNetworkUtil.getSelectedNodes(network);
        Graph graph = null;
        graph = this.app.convertCyNetworkToGraph(network, this.panel.getWeightAttributeName());
        if (graph == null) {
            this.setNodeSet(null);
            return;
        }
        IntArray indices = new IntArray();
        int i = 0;
        for (CyNode node : graph.getNodeMapping()) {
            if (selectedNodes.contains(node)) {
                indices.add(i);
            }
            ++i;
        }
        this.setNodeSet(new NodeSet((uk.ac.rhul.cs.graph.Graph)graph, indices.toArray()));
    }
}

