/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyNetworkUtil {
    public static Collection<CyEdge> getConnectingEdges(CyNetwork network, Collection<? extends CyNode> nodes) {
        HashSet<? extends CyNode> nodeSet = new HashSet<CyNode>(nodes);
        HashSet<CyEdge> resultSet = new HashSet<CyEdge>();
        for (CyNode cyNode : nodes) {
            for (CyEdge edge : network.getAdjacentEdgeIterable(cyNode, CyEdge.Type.ANY)) {
                if (!nodeSet.contains(edge.getSource()) || !nodeSet.contains(edge.getTarget())) continue;
                resultSet.add(edge);
            }
        }
        return resultSet;
    }

    public static List<CyEdge> getSelectedEdges(CyNetwork network) {
        return CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)true);
    }

    public static List<CyNode> getSelectedNodes(CyNetwork network) {
        return CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
    }

    public static void setSelectedState(CyNetwork network, Collection<? extends CyIdentifiable> nodesOrEdges, boolean value) {
        for (CyIdentifiable cyIdentifiable : nodesOrEdges) {
            network.getRow(cyIdentifiable).set("selected", (Object)value);
        }
    }

    public static void unselectAllEdges(CyNetwork network) {
        CyTable edgeTable = network.getDefaultEdgeTable();
        for (CyRow row : edgeTable.getMatchingRows("selected", (Object)true)) {
            row.set("selected", (Object)false);
        }
    }

    public static void unselectAllNodes(CyNetwork network) {
        CyTable nodeTable = network.getDefaultNodeTable();
        for (CyRow row : nodeTable.getMatchingRows("selected", (Object)true)) {
            row.set("selected", (Object)false);
        }
    }
}

