/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNodeUtil;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CytoscapeResultViewerPanel;
import uk.ac.rhul.cs.utils.StringUtils;

public class CopyClusterToClipboardAction
extends AbstractAction {
    protected CytoscapeResultViewerPanel resultViewer;
    private boolean hasClipboard = true;

    public CopyClusterToClipboardAction(CytoscapeResultViewerPanel panel) {
        super("Copy to clipboard");
        this.resultViewer = panel;
        this.putValue("MnemonicKey", 67);
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.hasClipboard = systemClipboard != null;
        this.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        if (!this.hasClipboard) {
            super.setEnabled(false);
        }
        super.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.hasClipboard) {
            return;
        }
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (systemClipboard == null) {
            return;
        }
        CyNetwork network = this.resultViewer.getNetwork();
        List<List<CyNode>> selectedNodeLists = this.resultViewer.getSelectedCytoscapeNodeSets();
        ArrayList<String> lines = new ArrayList<String>();
        for (List<CyNode> selectedNodes : selectedNodeLists) {
            ArrayList<String> nodeNames = new ArrayList<String>();
            for (CyNode node : selectedNodes) {
                nodeNames.add(CyNodeUtil.getName(network, node));
            }
            lines.add(StringUtils.join(nodeNames.iterator(), ' '));
        }
        systemClipboard.setContents(new StringSelection(StringUtils.join(lines.iterator(), '\n')), null);
    }
}

