/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapePlugin;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapeResultViewerPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.VisualStyleManager;
import uk.ac.rhul.cs.utils.Pair;

public class StartAction
extends CytoscapeAction {
    public StartAction() {
        super("Start");
        this.putValue("MnemonicKey", 83);
        this.setPreferredMenu("Plugins.ClusterONE");
    }

    public boolean isInToolBar() {
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
        if (network == null || network.getNodeCount() == 0) {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "You must select a non-empty network before starting ClusterONE", "Error - no network selected", 0);
            return;
        }
        ControlPanel panel = ControlPanel.getShownInstance();
        if (panel == null) {
            return;
        }
        Pair<List<ValuedNodeSet>, List<Node>> results = CytoscapePlugin.runAlgorithm(network, panel.getParameters(), panel.getWeightAttributeName(), true);
        if (results.getLeft() == null) {
            return;
        }
        VisualStyleManager.ensureVizMapperStylesRegistered(false);
        Cytoscape.getVisualMappingManager().setVisualStyle("ClusterONE - Status");
        Cytoscape.getVisualMappingManager().applyAppearances();
        networkView.redrawGraph(false, true);
        CytoscapeResultViewerPanel resultsPanel = new CytoscapeResultViewerPanel(network, networkView);
        resultsPanel.setNodeSets(results.getLeft());
        resultsPanel.setNodeMapping(results.getRight());
        resultsPanel.addToCytoscapeResultPanel();
    }
}

