/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import com.sosnoski.util.array.IntArray;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ui.NodeSetPropertiesPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapePlugin;
import uk.ac.rhul.cs.cl1.ui.cytoscape.Graph;
import uk.ac.rhul.cs.cl1.ui.cytoscape.NonNumericAttributeException;

public class SelectionPropertiesPanel
extends NodeSetPropertiesPanel
implements PropertyChangeListener,
GraphViewChangeListener {
    CyNetworkView watchedNetworkView = null;

    public SelectionPropertiesPanel(ControlPanel panel) {
        if (panel != null) {
            this.setQualityFunction(panel.getParameters().getQualityFunction());
        }
        this.setWatchedNetworkView(Cytoscape.getCurrentNetworkView());
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_VIEW_FOCUSED", this);
        this.updateNodeSetFromSelection();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("NETWORK_VIEW_FOCUSED".equals(e.getPropertyName())) {
            Object newValue = e.getNewValue();
            if (newValue instanceof CyNetworkView) {
                this.setWatchedNetworkView((CyNetworkView)e.getNewValue());
            }
            this.updateNodeSetFromSelection();
        }
    }

    private void setWatchedNetworkView(CyNetworkView networkView) {
        if (this.watchedNetworkView == networkView) {
            return;
        }
        if (this.watchedNetworkView != null) {
            this.watchedNetworkView.removeGraphViewChangeListener((GraphViewChangeListener)this);
        }
        this.watchedNetworkView = networkView;
        if (this.watchedNetworkView != null) {
            this.watchedNetworkView.addGraphViewChangeListener((GraphViewChangeListener)this);
        }
    }

    public void updateNodeSetFromSelection() {
        CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
        if (networkView == null) {
            return;
        }
        this.setWatchedNetworkView(Cytoscape.getCurrentNetworkView());
        CyNetwork network = networkView.getNetwork();
        if (network == null) {
            return;
        }
        Set selectedNodes = network.getSelectedNodes();
        Graph graph = null;
        try {
            graph = CytoscapePlugin.getNetworkCache().convertCyNetworkToGraph(network);
        }
        catch (NonNumericAttributeException e) {
            return;
        }
        if (graph == null) {
            return;
        }
        IntArray indices = new IntArray();
        int i = 0;
        for (Node node : graph.getNodeMapping()) {
            if (selectedNodes.contains(node)) {
                indices.add(i);
            }
            ++i;
        }
        this.setNodeSet(new NodeSet((uk.ac.rhul.cs.graph.Graph)graph, indices.toArray()));
    }

    public void graphViewChanged(GraphViewChangeEvent e) {
        if (e.getType() == 16 || e.getType() == 32) {
            this.updateNodeSetFromSelection();
        }
    }
}

