/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.hashmap;

import com.sosnoski.util.ObjectHashBase;
import com.sosnoski.util.SparseArrayIterator;
import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class ObjectKeyBase
extends ObjectHashBase {
    public ObjectKeyBase(int n, double d, Class clazz, Class clazz2, Object object) {
        super(n, d, clazz, object);
        this.setValueArray(Array.newInstance(clazz2, this.m_arraySize));
    }

    public ObjectKeyBase(ObjectKeyBase objectKeyBase) {
        super(objectKeyBase);
        Class<?> clazz = objectKeyBase.getValueArray().getClass().getComponentType();
        Object object = Array.newInstance(clazz, this.m_arraySize);
        System.arraycopy(objectKeyBase.getValueArray(), 0, object, 0, this.m_arraySize);
        this.setValueArray(object);
    }

    protected abstract Object getValueArray();

    protected abstract void setValueArray(Object var1);

    protected abstract void restructure(Object var1, Object var2);

    protected void reallocate(int n) {
        Object[] objectArray = this.getKeyArray();
        Class<?> clazz = objectArray.getClass().getComponentType();
        this.setKeyArray(Array.newInstance(clazz, n));
        Object object = this.getValueArray();
        clazz = object.getClass().getComponentType();
        this.setValueArray(Array.newInstance(clazz, n));
        this.restructure(objectArray, object);
    }

    protected abstract boolean reinsert(int var1);

    protected void internalRemove(int n) {
        Object[] objectArray = this.getKeyArray();
        objectArray[n] = null;
        --this.m_entryCount;
        while (objectArray[n = this.stepSlot(n)] != null) {
            this.reinsert(n);
        }
    }

    public void clear() {
        super.clear();
        Object object = this.getValueArray();
        if (!object.getClass().getComponentType().isPrimitive()) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = null;
                ++n;
            }
        }
    }

    public final Iterator iterator() {
        return SparseArrayIterator.buildIterator(this.getKeyArray());
    }
}

