% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fastas.R
\name{create_fastas}
\alias{create_fastas}
\title{Table To FASTA}
\usage{
create_fastas(
  no_marker = 0,
  no_taxa = 0,
  no_seq = 0,
  name_issue = 0,
  taxa_digits = 0,
  taxa_punct = 0,
  wrong_taxa = 0
)
}
\arguments{
\item{no_marker}{If set to 1 then will include records filtered out due to no marker data. Default is 0 to not include records with no marker data.}

\item{no_taxa}{If set to 1 then will include records filtered out due to no taxa data. Default is 0 to not include records with no taxa data.}

\item{no_seq}{If set to 1 then will include records filtered out due to no sequence data. Default is 0 to not include records with no sequence data.}

\item{name_issue}{If set to 1 then will include records filtered out due to genus and species names with more than two terms. Default is 0 to not include records with taxonomic naming issues.}

\item{taxa_digits}{If set to 1 then will include records filtered out due to genus or species names containing digits. Default is 0 to not include records with digits in the taxonomic naming.}

\item{taxa_punct}{If set to 1 then will include records filtered out due to the presence of punctuation in the genus or species names. Default is 0 to not include records with punctuation in the taxonomic naming.}

\item{wrong_taxa}{If set to 1 then will include records filtered out due to the incorrect genera based on the list of taxa initially submitted to the download program. Default is 0 to not include records of non-target taxa.}
}
\value{
This script outputs a fasta file of sequences for each column in the submitted parameters file. These files are named with the genera of interest and the first marker name in the column of the parameters file.
These files are located in the folder where the Total_tables.txt file is located.
}
\description{
Using the output table from the download script and the user built genus-marker name parameter file to take the downloaded data and place them into fasta files.
}
\details{
Input: File with list of genera with the molecular markers names below the taxa. The information to create this parameters file can be obtained from A_Summary.txt file from the download script results.
For further details please see the documentation.
}
\examples{
\dontrun{
create_fastas()
create_fastas(no_marker = 1, no_taxa = 1)
create_fastas(no_seq  = 1, name_issue = 1)
}

}
\references{
<https://github.com/rgyoung6/MACER>
Young, R. G., Gill, R., Gillis, D., Hanner, R. H. (Submitted June 2021). Molecular Acquisition, Cleaning, and Evaluation in R (MACER) - A tool to assemble molecular marker datasets from BOLD and GenBank. Biodiversity Data Journal.
}
\seealso{
create_fastas()
align_to_ref()
barcode_clean()
}
\author{
Rekkab Singh Gill
}
